/*
 * Decompiled with CFR 0.152.
 */
package net.gleske.jervis.tools;

import groovy.json.JsonBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.gleske.jervis.exceptions.DecryptException;
import net.gleske.jervis.exceptions.EncryptException;
import net.gleske.jervis.exceptions.KeyPairDecodeException;
import net.gleske.jervis.tools.YamlOperator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class SecurityIO
implements Serializable,
GroovyObject {
    private static Integer DEFAULT_AES_ITERATIONS;
    private transient KeyPair key_pair;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SecurityIO() {
        MetaClass metaClass;
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public SecurityIO(String private_key_pem) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this, (Object)private_key_pem);
        } else {
            this.setKey_pair(private_key_pem);
        }
    }

    public String signRS256Base64Url(String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        PKCS8EncodedKeySpec spec = (PKCS8EncodedKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(PKCS8EncodedKeySpec.class, callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty((Object)this.key_pair))), PKCS8EncodedKeySpec.class);
        KeyFactory kf = (KeyFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(KeyFactory.class, (Object)"RSA"), KeyFactory.class);
        Signature privateSignature = (Signature)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(Signature.class, (Object)"SHA256withRSA"), Signature.class);
        callSiteArray[6].call((Object)privateSignature, callSiteArray[7].call((Object)kf, (Object)spec));
        callSiteArray[8].call((Object)privateSignature, callSiteArray[9].call((Object)data, (Object)"UTF-8"));
        byte[] signedData = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)privateSignature), byte[].class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[11].callStatic(SecurityIO.class, (Object)signedData));
        }
        return SecurityIO.encodeBase64Url(signedData);
    }

    public Boolean verifyRS256Base64Url(String signature, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Signature publicSignature = (Signature)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call(Signature.class, (Object)"SHA256withRSA"), Signature.class);
        callSiteArray[13].call((Object)publicSignature, callSiteArray[14].callGetProperty((Object)this.key_pair));
        callSiteArray[15].call((Object)publicSignature, callSiteArray[16].callGetProperty((Object)data));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call((Object)publicSignature, callSiteArray[18].callStatic(SecurityIO.class, (Object)signature)), Boolean.class);
        }
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call((Object)publicSignature, (Object)SecurityIO.decodeBase64UrlBytes(signature)), Boolean.class);
    }

    public String getGitHubJWT(String github_app_id, Integer expiration, Integer drift) {
        public class _getGitHubJWT_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getGitHubJWT_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getGitHubJWT_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String data) {
                CallSite[] callSiteArray = _getGitHubJWT_closure1.$getCallSiteArray();
                return new GStringImpl(new Object[]{data, callSiteArray[0].callCurrent((GroovyObject)this, (Object)data)}, new String[]{"", ".", ""});
            }

            public Object call(String data) {
                CallSite[] callSiteArray = _getGitHubJWT_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)data);
                }
                return this.doCall(data);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getGitHubJWT_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "signRS256Base64Url";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getGitHubJWT_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getGitHubJWT_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getGitHubJWT_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)expiration, (Object)1)) {
            int n = 1;
            expiration = n;
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)expiration, (Object)10)) {
            int n = 10;
            expiration = n;
        }
        Instant issuedAt = (Instant)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call(callSiteArray[21].call(Instant.class), callSiteArray[22].call(Duration.class, (Object)drift)), Instant.class);
        Instant expiresAt = (Instant)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call((Object)issuedAt, callSiteArray[24].call(Duration.class, (Object)expiration)), Instant.class);
        String header = "{\"alg\":\"RS256\",\"typ\":\"JWT\"}";
        String payload = ShortTypeHandling.castToString((Object)callSiteArray[25].call((Object)((JsonBuilder)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"iat", callSiteArray[26].call((Object)issuedAt), "exp", callSiteArray[27].call((Object)expiresAt), "iss", github_app_id}), JsonBuilder.class))));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[28].call((Object)new GStringImpl(new Object[]{callSiteArray[29].callStatic(SecurityIO.class, (Object)header), callSiteArray[30].callStatic(SecurityIO.class, (Object)payload)}, new String[]{"", ".", ""}), (Object)new _getGitHubJWT_closure1(this, this)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[31].call((Object)new GStringImpl(new Object[]{SecurityIO.encodeBase64Url(header), SecurityIO.encodeBase64Url(payload)}, new String[]{"", ".", ""}), (Object)new _getGitHubJWT_closure1(this, this)));
    }

    public Boolean verifyJsonWebToken(String github_jwt) {
        List jwt;
        CallSite[] callSiteArray;
        block8: {
            callSiteArray = SecurityIO.$getCallSiteArray();
            jwt = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call((Object)github_jwt, (Object)"."), List.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[33].call((Object)jwt), (Object)3)) {
                return false;
            }
            Map header = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(YamlOperator.class, callSiteArray[35].callStatic(SecurityIO.class, callSiteArray[36].call((Object)jwt, (Object)0))), Map.class);
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[37].callGetProperty((Object)header), (Object)"RS256")) break block8;
            Boolean bl = false;
            try {
                return bl;
            }
            catch (Exception e) {
                Boolean bl2 = false;
                return bl2;
            }
        }
        String data = ShortTypeHandling.castToString((Object)callSiteArray[38].call(callSiteArray[39].call((Object)jwt, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)1, (boolean)true)), (Object)"."));
        String signature = ShortTypeHandling.castToString((Object)callSiteArray[40].call((Object)jwt, (Object)2));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callCurrent((GroovyObject)this, (Object)signature, (Object)data), Boolean.class);
        }
        return this.verifyRS256Base64Url(signature, data);
    }

    public Boolean verifyGitHubJWTPayload(String github_jwt, Integer drift) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callCurrent((GroovyObject)this, (Object)github_jwt)) : !DefaultTypeTransformation.booleanUnbox((Object)this.verifyJsonWebToken(github_jwt))) {
            return false;
        }
        Map payload = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(YamlOperator.class, callSiteArray[44].callStatic(SecurityIO.class, callSiteArray[45].call(callSiteArray[46].call((Object)github_jwt, (Object)"."), (Object)1))), Map.class);
        Integer time_since_epoch = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(Instant.class)), (Object)drift), Integer.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[50].callGetProperty((Object)payload), (Object)time_since_epoch) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[51].callGetProperty((Object)payload), (Object)time_since_epoch);
        }
        return ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[52].callGetProperty((Object)payload), (Object)time_since_epoch) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[53].callGetProperty((Object)payload), (Object)time_since_epoch);
    }

    public void setKey_pair(String pem) throws KeyPairDecodeException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        PEMParser parser = (PEMParser)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callConstructor(PEMParser.class, callSiteArray[55].callConstructor(StringReader.class, (Object)pem)), PEMParser.class);
        Object obj = callSiteArray[56].call((Object)parser);
        callSiteArray[57].call((Object)parser);
        if (!DefaultTypeTransformation.booleanUnbox((Object)obj)) {
            throw (Throwable)callSiteArray[58].callConstructor(KeyPairDecodeException.class, (Object)"Could not decode KeyPair from pem String.  readObject returned null.");
        }
        if (ScriptBytecodeAdapter.isCase((Object)obj, PrivateKeyInfo.class)) {
            Object object;
            obj = object = callSiteArray[59].callCurrent((GroovyObject)this, obj);
        }
        if (!ScriptBytecodeAdapter.isCase((Object)obj, PEMKeyPair.class)) {
            throw (Throwable)callSiteArray[61].callConstructor(KeyPairDecodeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[62].callGetProperty(obj)}, new String[]{"Could not decode KeyPair from pem String.  Unable to handle ", ""}));
        }
        callSiteArray[60].callCurrent((GroovyObject)this, obj);
    }

    private PEMKeyPair getKeypairFromPkcs8(PrivateKeyInfo pkInfo) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        ASN1Encodable pkcs1ASN1Encodable = (ASN1Encodable)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call((Object)pkInfo), ASN1Encodable.class);
        ASN1Primitive privateKeyPkcs1ASN1 = (ASN1Primitive)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call((Object)pkcs1ASN1Encodable), ASN1Primitive.class);
        StringWriter stringWriter = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].callConstructor(StringWriter.class), StringWriter.class);
        JcaPEMWriter jcaPEMWriter = (JcaPEMWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callConstructor(JcaPEMWriter.class, (Object)stringWriter), JcaPEMWriter.class);
        callSiteArray[67].call((Object)jcaPEMWriter, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((PemObjectGenerator)callSiteArray[68].callConstructor(PemObject.class, (Object)"RSA PRIVATE KEY", callSiteArray[69].call((Object)privateKeyPkcs1ASN1))), PemObjectGenerator.class));
        callSiteArray[70].call((Object)jcaPEMWriter);
        String pkcs1pem = ShortTypeHandling.castToString((Object)callSiteArray[71].call((Object)stringWriter));
        PEMParser parser = (PEMParser)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(PEMParser.class, callSiteArray[73].callConstructor(StringReader.class, (Object)pkcs1pem)), PEMParser.class);
        Object obj = callSiteArray[74].call((Object)parser);
        callSiteArray[75].call((Object)parser);
        return (PEMKeyPair)ScriptBytecodeAdapter.castToType((Object)obj, PEMKeyPair.class);
    }

    private void setPemKeyPair(PEMKeyPair obj) {
        KeyPair keyPair;
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call(Security.class, (Object)"BC"))) {
            callSiteArray[77].call(Security.class, callSiteArray[78].callConstructor(BouncyCastleProvider.class));
        }
        JcaPEMKeyConverter converter = (JcaPEMKeyConverter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].call(callSiteArray[80].callConstructor(JcaPEMKeyConverter.class), (Object)"BC"), JcaPEMKeyConverter.class);
        KeyPair parsedKeyPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call((Object)converter, (Object)obj), KeyPair.class);
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[82].call(callSiteArray[83].callGetProperty(callSiteArray[84].callGetProperty((Object)parsedKeyPair))), (Object)2048)) {
            String message = "Private keys smaller than 2048 are not allowed.";
            message = ShortTypeHandling.castToString((Object)callSiteArray[85].call((Object)message, (Object)"  Generate a new key pair 2048 bits or larger.\n\n"));
            message = ShortTypeHandling.castToString((Object)callSiteArray[86].call((Object)message, (Object)"Decrypt your old values using:\n\n    "));
            message = ShortTypeHandling.castToString((Object)callSiteArray[87].call((Object)message, (Object)"echo 'ciphertext' | openssl enc -base64 -A -d | openssl rsautl -decrypt -inkey path/to/id_rsa"));
            message = ShortTypeHandling.castToString((Object)callSiteArray[88].call((Object)message, (Object)"\n\nSee \"Enforcing stronger RSA keys\" section of the wiki article."));
            throw (Throwable)callSiteArray[89].callConstructor(KeyPairDecodeException.class, (Object)message);
        }
        this.key_pair = keyPair = parsedKeyPair;
    }

    public Integer getRsa_keysize() {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Object object = callSiteArray[90].callSafe(callSiteArray[91].callGetPropertySafe(callSiteArray[92].callGetPropertySafe((Object)this.key_pair)));
        return (Integer)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0)), Integer.class);
    }

    public static String decodeBase64String(String content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[93].callConstructor(String.class, callSiteArray[94].call(callSiteArray[95].call((Object)content))));
    }

    public static byte[] decodeBase64Bytes(String content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call(callSiteArray[97].call((Object)content)), byte[].class);
    }

    public String decodeBase64UrlString(String content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[98].callStatic(SecurityIO.class, callSiteArray[99].call((Object)content, (Object)"-_", (Object)"+/")));
    }

    public static byte[] decodeBase64UrlBytes(String content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].callStatic(SecurityIO.class, callSiteArray[101].call((Object)content, (Object)"-_", (Object)"+/")), byte[].class);
    }

    public static String encodeBase64(String content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[102].call(callSiteArray[103].call(callSiteArray[104].callGetProperty((Object)content))));
    }

    public static String encodeBase64(byte ... content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[105].call(callSiteArray[106].call((Object)content)));
    }

    public static String encodeBase64Url(String content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[107].call(callSiteArray[108].callStatic(SecurityIO.class, (Object)content), (Object)"+/", (Object)"-_"));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[109].call((Object)SecurityIO.encodeBase64(content), (Object)"+/", (Object)"-_"));
    }

    public static String encodeBase64Url(byte ... content) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[110].call(callSiteArray[111].callStatic(SecurityIO.class, (Object)content), (Object)"+/", (Object)"-_"));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[112].call((Object)SecurityIO.encodeBase64(content), (Object)"+/", (Object)"-_"));
    }

    public String rsaEncryptOaep(String plaintext) throws EncryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        byte[] ciphertext = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[113].callCurrent((GroovyObject)this, callSiteArray[114].callGetProperty((Object)plaintext)), byte[].class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[115].callStatic(SecurityIO.class, (Object)ciphertext));
        }
        return SecurityIO.encodeBase64(ciphertext);
    }

    public byte[] rsaEncryptBytesOaep(byte ... plainbytes) throws EncryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.key_pair)) {
            throw (Throwable)callSiteArray[116].callConstructor(EncryptException.class, (Object)"key_pair is not set.");
        }
        AsymmetricBlockCipher encrypt = (AsymmetricBlockCipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callConstructor(OAEPEncoding.class, callSiteArray[118].callConstructor(RSAEngine.class)), AsymmetricBlockCipher.class);
        callSiteArray[119].call((Object)encrypt, (Object)true, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((AsymmetricKeyParameter)ScriptBytecodeAdapter.asType((Object)callSiteArray[120].call(PublicKeyFactory.class, callSiteArray[121].callGetProperty(callSiteArray[122].callGetProperty((Object)this.key_pair))), AsymmetricKeyParameter.class)), AsymmetricKeyParameter.class));
        byte[] enciphered = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)encrypt, (Object)plainbytes, (Object)0, callSiteArray[124].callGetProperty((Object)plainbytes)), byte[].class);
        return enciphered;
    }

    public String rsaDecryptOaep(String ciphertext) throws DecryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] messageBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].callStatic(SecurityIO.class, (Object)ciphertext), byte[].class);
            return ShortTypeHandling.castToString((Object)callSiteArray[126].callConstructor(String.class, callSiteArray[127].callCurrent((GroovyObject)this, (Object)messageBytes)));
        }
        byte[] messageBytes = SecurityIO.decodeBase64Bytes(ciphertext);
        return ShortTypeHandling.castToString((Object)callSiteArray[128].callConstructor(String.class, (Object)this.rsaDecryptBytesOaep(messageBytes)));
    }

    public byte[] rsaDecryptBytesOaep(byte ... cipherbytes) throws DecryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.key_pair)) {
            throw (Throwable)callSiteArray[129].callConstructor(DecryptException.class, (Object)"key_pair is not set.");
        }
        AsymmetricBlockCipher decrypt = (AsymmetricBlockCipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].callConstructor(OAEPEncoding.class, callSiteArray[131].callConstructor(RSAEngine.class)), AsymmetricBlockCipher.class);
        callSiteArray[132].call((Object)decrypt, (Object)false, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((AsymmetricKeyParameter)ScriptBytecodeAdapter.asType((Object)callSiteArray[133].call(PrivateKeyFactory.class, callSiteArray[134].callGetProperty(callSiteArray[135].callGetProperty((Object)this.key_pair))), AsymmetricKeyParameter.class)), AsymmetricKeyParameter.class));
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].call((Object)decrypt, (Object)cipherbytes, (Object)0, callSiteArray[137].callGetProperty((Object)cipherbytes)), byte[].class);
    }

    @Deprecated
    public String rsaEncrypt(String plaintext) throws EncryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        byte[] ciphertext = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].callCurrent((GroovyObject)this, callSiteArray[139].callGetProperty((Object)plaintext)), byte[].class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[140].callStatic(SecurityIO.class, (Object)ciphertext));
        }
        return SecurityIO.encodeBase64(ciphertext);
    }

    @Deprecated
    public byte[] rsaEncryptBytes(byte ... plainbytes) throws EncryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.key_pair)) {
            throw (Throwable)callSiteArray[141].callConstructor(EncryptException.class, (Object)"key_pair is not set.");
        }
        AsymmetricBlockCipher encrypt = (AsymmetricBlockCipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callConstructor(PKCS1Encoding.class, callSiteArray[143].callConstructor(RSAEngine.class)), AsymmetricBlockCipher.class);
        callSiteArray[144].call((Object)encrypt, (Object)true, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((AsymmetricKeyParameter)ScriptBytecodeAdapter.asType((Object)callSiteArray[145].call(PublicKeyFactory.class, callSiteArray[146].callGetProperty(callSiteArray[147].callGetProperty((Object)this.key_pair))), AsymmetricKeyParameter.class)), AsymmetricKeyParameter.class));
        byte[] enciphered = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].call((Object)encrypt, (Object)plainbytes, (Object)0, callSiteArray[149].callGetProperty((Object)plainbytes)), byte[].class);
        return enciphered;
    }

    @Deprecated
    public String rsaDecrypt(String ciphertext) throws DecryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] messageBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].callStatic(SecurityIO.class, (Object)ciphertext), byte[].class);
            return ShortTypeHandling.castToString((Object)callSiteArray[151].callConstructor(String.class, callSiteArray[152].callCurrent((GroovyObject)this, (Object)messageBytes)));
        }
        byte[] messageBytes = SecurityIO.decodeBase64Bytes(ciphertext);
        return ShortTypeHandling.castToString((Object)callSiteArray[153].callConstructor(String.class, (Object)this.rsaDecryptBytes(messageBytes)));
    }

    @Deprecated
    public byte[] rsaDecryptBytes(byte ... cipherbytes) throws DecryptException {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.key_pair)) {
            throw (Throwable)callSiteArray[154].callConstructor(DecryptException.class, (Object)"key_pair is not set.");
        }
        AsymmetricBlockCipher decrypt = (AsymmetricBlockCipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callConstructor(PKCS1Encoding.class, callSiteArray[156].callConstructor(RSAEngine.class)), AsymmetricBlockCipher.class);
        callSiteArray[157].call((Object)decrypt, (Object)false, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((AsymmetricKeyParameter)ScriptBytecodeAdapter.asType((Object)callSiteArray[158].call(PrivateKeyFactory.class, callSiteArray[159].callGetProperty(callSiteArray[160].callGetProperty((Object)this.key_pair))), AsymmetricKeyParameter.class)), AsymmetricKeyParameter.class));
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].call((Object)decrypt, (Object)cipherbytes, (Object)0, callSiteArray[162].callGetProperty((Object)cipherbytes)), byte[].class);
    }

    public static Boolean isSecureField(Object field) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return field instanceof Map && ScriptBytecodeAdapter.isCase((Object)"secure", (Object)callSiteArray[163].call(field));
    }

    public static Object avoidTimingAttack(Integer milliseconds, Closure body) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Long desiredTime = (Long)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.compareLessThan((Object)milliseconds, (Object)0) ? callSiteArray[164].call(callSiteArray[165].call(SecureRandom.class, (Object)"NativePRNGNonBlocking"), callSiteArray[166].call((Object)milliseconds, (Object)-1)) : milliseconds), Long.class);
        Long before = (Long)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].call(callSiteArray[168].call(Instant.class)), Long.class);
        Object result = callSiteArray[169].call((Object)body);
        Long remainingTime = (Long)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].call((Object)desiredTime, callSiteArray[171].call(callSiteArray[172].call(callSiteArray[173].call(Instant.class)), (Object)before)), Long.class);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)remainingTime, (Object)0)) {
            callSiteArray[174].callStatic(SecurityIO.class, (Object)remainingTime);
        }
        return result;
    }

    public static String sha256Sum(String input) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[175].callStatic(SecurityIO.class, callSiteArray[176].callGetProperty((Object)input)));
    }

    public static String sha256Sum(byte ... input) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        MessageDigest digest = (MessageDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].call(MessageDigest.class, (Object)"SHA-256"), MessageDigest.class);
        callSiteArray[178].call((Object)digest, (Object)input);
        return ShortTypeHandling.castToString((Object)callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].callConstructor(BigInteger.class, (Object)1, callSiteArray[182].call((Object)digest)), (Object)16), (Object)64, (Object)"0"));
    }

    public static byte[] randomBytes(int size) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        SecureRandom rand = (SecureRandom)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].call(SecureRandom.class, (Object)"NativePRNGNonBlocking"), SecureRandom.class);
        byte[] random = new byte[size];
        callSiteArray[184].call((Object)rand, (Object)random);
        return random;
    }

    public static String randomBytesBase64(int size) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[185].callStatic(SecurityIO.class, callSiteArray[186].callStatic(SecurityIO.class, (Object)size)));
        }
        return SecurityIO.encodeBase64(SecurityIO.randomBytes(size));
    }

    public static byte[] encryptWithAES256GCM(byte[] secret, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        byte[] nonce = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[187].callStatic(SecurityIO.class, (Object)12);
            nonce = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            nonce = byArray = SecurityIO.randomBytes(12);
        }
        SecretKey key = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[188].callConstructor(SecretKeySpec.class, callSiteArray[189].callStatic(SecurityIO.class, (Object)secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        } else {
            Object object = callSiteArray[190].callConstructor(SecretKeySpec.class, (Object)SecurityIO.padForAES256(secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        }
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].call(Cipher.class, (Object)"AES/GCM/NoPadding"), Cipher.class);
        GCMParameterSpec gcmSpec = (GCMParameterSpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[192].callConstructor(GCMParameterSpec.class, (Object)128, (Object)nonce), GCMParameterSpec.class);
        callSiteArray[193].call((Object)cipher, callSiteArray[194].callGetProperty(Cipher.class), (Object)key, (Object)gcmSpec);
        byte[] ciphertext = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[195].call((Object)cipher, callSiteArray[196].call((Object)data, (Object)"UTF-8")), byte[].class);
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[197].callConstructor(ByteArrayOutputStream.class), ByteArrayOutputStream.class);
        callSiteArray[198].call((Object)outputStream, (Object)nonce);
        callSiteArray[199].call((Object)outputStream, (Object)ciphertext);
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[200].call((Object)outputStream), byte[].class);
    }

    public static String decryptWithAES256GCM(byte[] secret, byte ... data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[201].callGetProperty((Object)data), (Object)28)) {
            throw (Throwable)callSiteArray[202].callConstructor(DecryptException.class, (Object)"Ciphertext too short - missing nonce or auth tag");
        }
        byte[] nonce = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].call(Arrays.class, (Object)data, (Object)0, (Object)12), byte[].class);
        byte[] ciphertext = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[204].call(Arrays.class, (Object)data, (Object)12, callSiteArray[205].callGetProperty((Object)data)), byte[].class);
        SecretKey key = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[206].callConstructor(SecretKeySpec.class, callSiteArray[207].callStatic(SecurityIO.class, (Object)secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        } else {
            Object object = callSiteArray[208].callConstructor(SecretKeySpec.class, (Object)SecurityIO.padForAES256(secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        }
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].call(Cipher.class, (Object)"AES/GCM/NoPadding"), Cipher.class);
        GCMParameterSpec gcmSpec = (GCMParameterSpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[210].callConstructor(GCMParameterSpec.class, (Object)128, (Object)nonce), GCMParameterSpec.class);
        callSiteArray[211].call((Object)cipher, callSiteArray[212].callGetProperty(Cipher.class), (Object)key, (Object)gcmSpec);
        return ShortTypeHandling.castToString((Object)callSiteArray[213].callConstructor(String.class, callSiteArray[214].call((Object)cipher, (Object)ciphertext), (Object)"UTF-8"));
    }

    public static String encryptWithAES256GCMBase64(String secret, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[215].callStatic(SecurityIO.class, (Object)secret), byte[].class);
            return ShortTypeHandling.castToString((Object)callSiteArray[216].callStatic(SecurityIO.class, callSiteArray[217].callStatic(SecurityIO.class, (Object)b_secret, (Object)data)));
        }
        byte[] b_secret = SecurityIO.decodeBase64Bytes(secret);
        return SecurityIO.encodeBase64(SecurityIO.encryptWithAES256GCM(b_secret, data));
    }

    public static String decryptWithAES256GCMBase64(String secret, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[218].callStatic(SecurityIO.class, (Object)secret), byte[].class);
            byte[] b_data = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[219].callStatic(SecurityIO.class, (Object)data), byte[].class);
            return ShortTypeHandling.castToString((Object)callSiteArray[220].callStatic(SecurityIO.class, (Object)b_secret, (Object)b_data));
        }
        byte[] b_secret = SecurityIO.decodeBase64Bytes(secret);
        byte[] b_data = SecurityIO.decodeBase64Bytes(data);
        return SecurityIO.decryptWithAES256GCM(b_secret, b_data);
    }

    @Deprecated
    public static byte[] encryptWithAES256(byte[] secret, byte[] iv, String data, Integer hash_iterations) {
        Reference iv2 = new Reference((Object)iv);
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Reference checksum = new Reference(null);
        String cfr_ignored_0 = (String)checksum.get();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)hash_iterations, (Object)0)) {
            Integer iterations = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].call((Object)hash_iterations, (Object)1), Integer.class);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[222].callStatic(SecurityIO.class, (Object)((byte[])iv2.get()));
                checksum.set((Object)ShortTypeHandling.castToString((Object)object));
            } else {
                String string = SecurityIO.sha256Sum((byte[])iv2.get());
                checksum.set((Object)string);
            }
            public class _encryptWithAES256_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference checksum;
                private /* synthetic */ Reference iv;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _encryptWithAES256_closure2(Object _outerInstance, Object _thisObject, Reference checksum, Reference iv) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _encryptWithAES256_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.checksum = reference2 = checksum;
                    this.iv = reference = iv;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _encryptWithAES256_closure2.$getCallSiteArray();
                    Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((byte[])ScriptBytecodeAdapter.asType((Object)callSiteArray[1].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.iv.get(), callSiteArray[2].callGetProperty(this.checksum.get())})), byte[].class)), byte[].class));
                    this.checksum.set((Object)ShortTypeHandling.castToString((Object)object));
                    return object;
                }

                public String getChecksum() {
                    CallSite[] callSiteArray = _encryptWithAES256_closure2.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.checksum.get());
                }

                public byte[] getIv() {
                    CallSite[] callSiteArray = _encryptWithAES256_closure2.$getCallSiteArray();
                    return (byte[])ScriptBytecodeAdapter.castToType((Object)this.iv.get(), byte[].class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _encryptWithAES256_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptWithAES256_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "sha256Sum";
                    stringArray[1] = "flatten";
                    stringArray[2] = "bytes";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _encryptWithAES256_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptWithAES256_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptWithAES256_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[223].call((Object)iterations, (Object)new _encryptWithAES256_closure2(SecurityIO.class, SecurityIO.class, checksum, iv2));
        }
        byte[] b_iv = null;
        if (!BytecodeInterface8.isOrigB() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] byArray = DefaultTypeTransformation.booleanUnbox((Object)((String)checksum.get())) ? (Object)callSiteArray[224].call(callSiteArray[225].callStatic(SecurityIO.class, (Object)((String)checksum.get()), (Object)((String)checksum.get())), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)15, (boolean)true)) : (byte[])iv2.get();
            b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)byArray, byte[].class);
        } else {
            byte[] byArray = DefaultTypeTransformation.booleanUnbox((Object)((String)checksum.get())) ? (Object)callSiteArray[226].call((Object)SecurityIO.passwordKeyDerivation((String)checksum.get(), (String)checksum.get()), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)15, (boolean)true)) : (byte[])iv2.get();
            b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)byArray, byte[].class);
        }
        SecretKey key = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[227].callConstructor(SecretKeySpec.class, callSiteArray[228].callStatic(SecurityIO.class, (Object)secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        } else {
            Object object = callSiteArray[229].callConstructor(SecretKeySpec.class, (Object)SecurityIO.padForAES256(secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        }
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[230].call(Cipher.class, (Object)"AES/CBC/PKCS5Padding"), Cipher.class);
        callSiteArray[231].call((Object)cipher, callSiteArray[232].callGetProperty(Cipher.class), (Object)key, callSiteArray[233].callConstructor(IvParameterSpec.class, (Object)b_iv));
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[234].call((Object)cipher, callSiteArray[235].call((Object)data, (Object)"UTF-8")), byte[].class);
    }

    @Deprecated
    public static String decryptWithAES256(byte[] secret, byte[] iv, byte[] data, Integer hash_iterations) {
        Reference iv2 = new Reference((Object)iv);
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Reference checksum = new Reference(null);
        String cfr_ignored_0 = (String)checksum.get();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)hash_iterations, (Object)0)) {
            Integer iterations = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[236].call((Object)hash_iterations, (Object)1), Integer.class);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[237].callStatic(SecurityIO.class, (Object)((byte[])iv2.get()));
                checksum.set((Object)ShortTypeHandling.castToString((Object)object));
            } else {
                String string = SecurityIO.sha256Sum((byte[])iv2.get());
                checksum.set((Object)string);
            }
            public class _decryptWithAES256_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference checksum;
                private /* synthetic */ Reference iv;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _decryptWithAES256_closure3(Object _outerInstance, Object _thisObject, Reference checksum, Reference iv) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _decryptWithAES256_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.checksum = reference2 = checksum;
                    this.iv = reference = iv;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _decryptWithAES256_closure3.$getCallSiteArray();
                    Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((byte[])ScriptBytecodeAdapter.asType((Object)callSiteArray[1].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.iv.get(), callSiteArray[2].callGetProperty(this.checksum.get())})), byte[].class)), byte[].class));
                    this.checksum.set((Object)ShortTypeHandling.castToString((Object)object));
                    return object;
                }

                public String getChecksum() {
                    CallSite[] callSiteArray = _decryptWithAES256_closure3.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.checksum.get());
                }

                public byte[] getIv() {
                    CallSite[] callSiteArray = _decryptWithAES256_closure3.$getCallSiteArray();
                    return (byte[])ScriptBytecodeAdapter.castToType((Object)this.iv.get(), byte[].class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _decryptWithAES256_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptWithAES256_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "sha256Sum";
                    stringArray[1] = "flatten";
                    stringArray[2] = "bytes";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _decryptWithAES256_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_decryptWithAES256_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptWithAES256_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[238].call((Object)iterations, (Object)new _decryptWithAES256_closure3(SecurityIO.class, SecurityIO.class, checksum, iv2));
        }
        byte[] b_iv = null;
        if (!BytecodeInterface8.isOrigB() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] byArray = DefaultTypeTransformation.booleanUnbox((Object)((String)checksum.get())) ? (Object)callSiteArray[239].call(callSiteArray[240].callStatic(SecurityIO.class, (Object)((String)checksum.get()), (Object)((String)checksum.get())), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)15, (boolean)true)) : (byte[])iv2.get();
            b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)byArray, byte[].class);
        } else {
            byte[] byArray = DefaultTypeTransformation.booleanUnbox((Object)((String)checksum.get())) ? (Object)callSiteArray[241].call((Object)SecurityIO.passwordKeyDerivation((String)checksum.get(), (String)checksum.get()), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)15, (boolean)true)) : (byte[])iv2.get();
            b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)byArray, byte[].class);
        }
        SecretKey key = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[242].callConstructor(SecretKeySpec.class, callSiteArray[243].callStatic(SecurityIO.class, (Object)secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        } else {
            Object object = callSiteArray[244].callConstructor(SecretKeySpec.class, (Object)SecurityIO.padForAES256(secret), (Object)0, (Object)32, (Object)"AES");
            key = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        }
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[245].call(Cipher.class, (Object)"AES/CBC/PKCS5Padding"), Cipher.class);
        callSiteArray[246].call((Object)cipher, callSiteArray[247].callGetProperty(Cipher.class), (Object)key, callSiteArray[248].callConstructor(IvParameterSpec.class, (Object)b_iv));
        return ShortTypeHandling.castToString((Object)callSiteArray[249].callConstructor(String.class, callSiteArray[250].call((Object)cipher, (Object)data), (Object)"UTF-8"));
    }

    @Deprecated
    public static String encryptWithAES256Base64(String secret, String iv, String data, Integer hash_iterations) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[251].callStatic(SecurityIO.class, (Object)secret), byte[].class);
            byte[] b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callStatic(SecurityIO.class, (Object)iv), byte[].class);
            return ShortTypeHandling.castToString((Object)callSiteArray[253].callStatic(SecurityIO.class, callSiteArray[254].callStatic(SecurityIO.class, (Object)b_secret, (Object)b_iv, (Object)data, (Object)hash_iterations)));
        }
        byte[] b_secret = SecurityIO.decodeBase64Bytes(secret);
        byte[] b_iv = SecurityIO.decodeBase64Bytes(iv);
        return SecurityIO.encodeBase64(SecurityIO.encryptWithAES256(b_secret, b_iv, data, hash_iterations));
    }

    @Deprecated
    public static String decryptWithAES256Base64(String secret, String iv, String data, Integer hash_iterations) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            byte[] b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[255].callStatic(SecurityIO.class, (Object)secret), byte[].class);
            byte[] b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[256].callStatic(SecurityIO.class, (Object)iv), byte[].class);
            byte[] b_data = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[257].callStatic(SecurityIO.class, (Object)data), byte[].class);
            return ShortTypeHandling.castToString((Object)callSiteArray[258].callStatic(SecurityIO.class, (Object)b_secret, (Object)b_iv, (Object)b_data, (Object)hash_iterations));
        }
        byte[] b_secret = SecurityIO.decodeBase64Bytes(secret);
        byte[] b_iv = SecurityIO.decodeBase64Bytes(iv);
        byte[] b_data = SecurityIO.decodeBase64Bytes(data);
        return SecurityIO.decryptWithAES256(b_secret, b_iv, b_data, hash_iterations);
    }

    public static byte[] padForAES256(byte ... input) {
        Reference input2 = new Reference((Object)input);
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[259].call((Object)((byte[])input2.get())), (Object)32)) {
            return (byte[])input2.get();
        }
        Integer n = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[260].call(callSiteArray[261].call((Object)32, callSiteArray[262].call(callSiteArray[263].call((Object)((byte[])input2.get())), (Object)1)), (Object)1), Integer.class);
        Reference b_list = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{(byte[])input2.get()}));
        public class _padForAES256_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference b_list;
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _padForAES256_closure4(Object _outerInstance, Object _thisObject, Reference b_list, Reference input) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _padForAES256_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.b_list = reference2 = b_list;
                this.input = reference = input;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _padForAES256_closure4.$getCallSiteArray();
                return callSiteArray[0].call(this.b_list.get(), this.input.get());
            }

            public List getB_list() {
                CallSite[] callSiteArray = _padForAES256_closure4.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.b_list.get(), List.class);
            }

            public byte[] getInput() {
                CallSite[] callSiteArray = _padForAES256_closure4.$getCallSiteArray();
                return (byte[])ScriptBytecodeAdapter.castToType((Object)this.input.get(), byte[].class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _padForAES256_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _padForAES256_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "leftShift";
                return new CallSiteArray(_padForAES256_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _padForAES256_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[264].call((Object)n, (Object)new _padForAES256_closure4(SecurityIO.class, SecurityIO.class, b_list, input2));
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[265].call(callSiteArray[266].call((Object)((List)b_list.get())), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)31, (boolean)true)), byte[].class);
    }

    private static Integer iterationDerivation(String shasum) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Reference maxMultiplier = new Reference((Object)1000);
        Integer minIterations = 100100;
        Reference keyIndex = new Reference((Object)"0123456789abcdef");
        Reference subtract = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public class _iterationDerivation_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference subtract;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _iterationDerivation_closure5(Object _outerInstance, Object _thisObject, Reference subtract) {
                Reference reference;
                CallSite[] callSiteArray = _iterationDerivation_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.subtract = reference = subtract;
            }

            public Object doCall(String c) {
                CallSite[] callSiteArray = _iterationDerivation_closure5.$getCallSiteArray();
                Set keyset = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.subtract.get()), Set.class);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call((Object)keyset), (Object)4) || ScriptBytecodeAdapter.isCase((Object)c, (Object)keyset)) {
                    return null;
                }
                Integer negative = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call((Object)1, callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call((Object)keyset), (Object)10), (Object)2)), Integer.class);
                Object object = callSiteArray[6].call((Object)-1, (Object)negative);
                callSiteArray[7].call(this.subtract.get(), (Object)c, object);
                return object;
            }

            public Object call(String c) {
                CallSite[] callSiteArray = _iterationDerivation_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[8].callCurrent((GroovyObject)this, (Object)c);
                }
                return this.doCall(c);
            }

            public Map getSubtract() {
                CallSite[] callSiteArray = _iterationDerivation_closure5.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.subtract.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _iterationDerivation_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "keySet";
                stringArray[1] = "size";
                stringArray[2] = "plus";
                stringArray[3] = "div";
                stringArray[4] = "multiply";
                stringArray[5] = "size";
                stringArray[6] = "multiply";
                stringArray[7] = "putAt";
                stringArray[8] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                _iterationDerivation_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_iterationDerivation_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _iterationDerivation_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public class _iterationDerivation_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference subtract;
            private /* synthetic */ Reference keyIndex;
            private /* synthetic */ Reference maxMultiplier;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _iterationDerivation_closure6(Object _outerInstance, Object _thisObject, Reference subtract, Reference keyIndex, Reference maxMultiplier) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _iterationDerivation_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.subtract = reference3 = subtract;
                this.keyIndex = reference2 = keyIndex;
                this.maxMultiplier = reference = maxMultiplier;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _iterationDerivation_closure6.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)it, (Object)callSiteArray[0].call(this.subtract.get())) ? callSiteArray[1].call(this.subtract.get(), it) : callSiteArray[2].call(callSiteArray[3].call(this.keyIndex.get(), it), this.maxMultiplier.get());
            }

            public Map getSubtract() {
                CallSite[] callSiteArray = _iterationDerivation_closure6.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.subtract.get(), Map.class);
            }

            public String getKeyIndex() {
                CallSite[] callSiteArray = _iterationDerivation_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.keyIndex.get());
            }

            public Integer getMaxMultiplier() {
                CallSite[] callSiteArray = _iterationDerivation_closure6.$getCallSiteArray();
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxMultiplier.get(), Integer.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _iterationDerivation_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _iterationDerivation_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "keySet";
                stringArray[1] = "getAt";
                stringArray[2] = "multiply";
                stringArray[3] = "indexOf";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _iterationDerivation_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_iterationDerivation_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _iterationDerivation_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Integer iterations = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[267].call(callSiteArray[268].call(callSiteArray[269].call(callSiteArray[270].call(callSiteArray[271].call((Object)shasum), (Object)new _iterationDerivation_closure5(SecurityIO.class, SecurityIO.class, subtract)), (Object)new _iterationDerivation_closure6(SecurityIO.class, SecurityIO.class, subtract, keyIndex, maxMultiplier)))), Integer.class);
        return (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[272].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{minIterations, iterations})), Integer.class);
    }

    private static byte[] passwordKeyDerivation(String passphrase, String shasum) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        Integer iterations = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[273].callStatic(SecurityIO.class, (Object)shasum);
            iterations = (Integer)ScriptBytecodeAdapter.castToType((Object)object, Integer.class);
        } else {
            Integer n;
            iterations = n = SecurityIO.iterationDerivation(shasum);
        }
        SecretKeyFactory factory = (SecretKeyFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[274].call(SecretKeyFactory.class, (Object)"PBKDF2WithHmacSHA256"), SecretKeyFactory.class);
        KeySpec spec = (KeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[275].callConstructor(PBEKeySpec.class, callSiteArray[276].call((Object)passphrase), callSiteArray[277].call((Object)shasum), (Object)iterations, (Object)256), KeySpec.class);
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[278].call(callSiteArray[279].call((Object)factory, (Object)spec)), byte[].class);
    }

    public static String encryptWithPassphraseGCM(String passphrase, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        byte[] randomSalt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[280].callStatic(SecurityIO.class, (Object)32);
            randomSalt = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            randomSalt = byArray = SecurityIO.randomBytes(32);
        }
        String saltHex = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[281].callStatic(SecurityIO.class, (Object)randomSalt);
            saltHex = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            saltHex = string = SecurityIO.encodeBase64(randomSalt);
        }
        byte[] b_secret = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[282].callStatic(SecurityIO.class, (Object)passphrase, (Object)saltHex);
            b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            b_secret = byArray = SecurityIO.passwordKeyDerivation(passphrase, saltHex);
        }
        byte[] ciphertext = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[283].callStatic(SecurityIO.class, (Object)b_secret, (Object)data);
            ciphertext = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            ciphertext = byArray = SecurityIO.encryptWithAES256GCM(b_secret, data);
        }
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[284].callConstructor(ByteArrayOutputStream.class), ByteArrayOutputStream.class);
        callSiteArray[285].call((Object)outputStream, (Object)randomSalt);
        callSiteArray[286].call((Object)outputStream, (Object)ciphertext);
        return ShortTypeHandling.castToString((Object)callSiteArray[287].callStatic(SecurityIO.class, callSiteArray[288].call((Object)outputStream)));
    }

    public static String decryptWithPassphraseGCM(String passphrase, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        byte[] fullData = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[289].callStatic(SecurityIO.class, (Object)data);
            fullData = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            fullData = byArray = SecurityIO.decodeBase64Bytes(data);
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[290].callGetProperty((Object)fullData), (Object)60)) {
            throw (Throwable)callSiteArray[291].callConstructor(DecryptException.class, (Object)"Ciphertext too short - missing salt, nonce, or auth tag");
        }
        byte[] randomSalt = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[292].call(Arrays.class, (Object)fullData, (Object)0, (Object)32), byte[].class);
        byte[] ciphertextWithNonce = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[293].call(Arrays.class, (Object)fullData, (Object)32, callSiteArray[294].callGetProperty((Object)fullData)), byte[].class);
        String saltHex = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[295].callStatic(SecurityIO.class, (Object)randomSalt);
            saltHex = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            saltHex = string = SecurityIO.encodeBase64(randomSalt);
        }
        byte[] b_secret = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[296].callStatic(SecurityIO.class, (Object)passphrase, (Object)saltHex);
            b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            b_secret = byArray = SecurityIO.passwordKeyDerivation(passphrase, saltHex);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[297].callStatic(SecurityIO.class, (Object)b_secret, (Object)ciphertextWithNonce));
        }
        return SecurityIO.decryptWithAES256GCM(b_secret, ciphertextWithNonce);
    }

    @Deprecated
    public static String encryptWithAES256(String passphrase, String data, Integer hash_iterations) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        String salt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[298].call(callSiteArray[299].callStatic(SecurityIO.class, (Object)passphrase));
            salt = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[300].call((Object)SecurityIO.sha256Sum(passphrase));
            salt = ShortTypeHandling.castToString((Object)object);
        }
        byte[] b_secret = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[301].callStatic(SecurityIO.class, (Object)passphrase, (Object)salt);
            b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            b_secret = byArray = SecurityIO.passwordKeyDerivation(passphrase, salt);
        }
        byte[] b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[302].call(callSiteArray[303].call((Object)salt, (Object)0, (Object)16), (Object)"UTF-8"), byte[].class);
        Integer iterations = ScriptBytecodeAdapter.compareGreaterThan((Object)hash_iterations, (Object)0) ? hash_iterations : Integer.valueOf(1);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[304].callStatic(SecurityIO.class, callSiteArray[305].callStatic(SecurityIO.class, (Object)b_secret, (Object)b_iv, (Object)data, (Object)iterations)));
        }
        return SecurityIO.encodeBase64(SecurityIO.encryptWithAES256(b_secret, b_iv, data, iterations));
    }

    @Deprecated
    public static String decryptWithAES256(String passphrase, String data, Integer hash_iterations) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        String salt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[306].call(callSiteArray[307].callStatic(SecurityIO.class, (Object)passphrase));
            salt = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[308].call((Object)SecurityIO.sha256Sum(passphrase));
            salt = ShortTypeHandling.castToString((Object)object);
        }
        byte[] b_secret = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[309].callStatic(SecurityIO.class, (Object)passphrase, (Object)salt);
            b_secret = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            b_secret = byArray = SecurityIO.passwordKeyDerivation(passphrase, salt);
        }
        byte[] b_iv = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[310].call(callSiteArray[311].call((Object)salt, (Object)0, (Object)16), (Object)"UTF-8"), byte[].class);
        byte[] b_data = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[312].callStatic(SecurityIO.class, (Object)data);
            b_data = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            byte[] byArray;
            b_data = byArray = SecurityIO.decodeBase64Bytes(data);
        }
        Integer iterations = ScriptBytecodeAdapter.compareGreaterThan((Object)hash_iterations, (Object)0) ? hash_iterations : Integer.valueOf(1);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[313].callStatic(SecurityIO.class, (Object)b_secret, (Object)b_iv, (Object)b_data, (Object)iterations));
        }
        return SecurityIO.decryptWithAES256(b_secret, b_iv, b_data, iterations);
    }

    public static Boolean isBase64(String s) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[314].call(callSiteArray[315].call((Object)s)), (Object)0)) {
            return true;
        }
        String normalized = ShortTypeHandling.castToString((Object)callSiteArray[316].call(callSiteArray[317].call(callSiteArray[318].call((Object)s, (Object)"\n"), (Object)"")));
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[319].call((Object)normalized), (Object)4)) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[320].call(callSiteArray[321].call((Object)normalized), (Object)4), (Object)0)) {
            return false;
        }
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)normalized, (Object)"^[0-9a-zA-Z+/]*={0,2}$"), Boolean.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SecurityIO.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public String getGitHubJWT(String github_app_id, Integer expiration) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getGitHubJWT(github_app_id, expiration, 30);
        }
        return this.getGitHubJWT(github_app_id, expiration, 30);
    }

    public String getGitHubJWT(String github_app_id) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getGitHubJWT(github_app_id, 10, 30);
        }
        return this.getGitHubJWT(github_app_id, 10, 30);
    }

    public Boolean verifyGitHubJWTPayload(String github_jwt) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.verifyGitHubJWTPayload(github_jwt, 30);
        }
        return this.verifyGitHubJWTPayload(github_jwt, 30);
    }

    @Deprecated
    public static byte[] encryptWithAES256(byte[] secret, byte[] iv, String data) {
        Reference iv2 = new Reference((Object)iv);
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SecurityIO.encryptWithAES256(secret, (byte[])iv2.get(), data, DEFAULT_AES_ITERATIONS);
        }
        return SecurityIO.encryptWithAES256(secret, (byte[])iv2.get(), data, DEFAULT_AES_ITERATIONS);
    }

    @Deprecated
    public static String decryptWithAES256(byte[] secret, byte[] iv, byte ... data) {
        Reference iv2 = new Reference((Object)iv);
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SecurityIO.decryptWithAES256(secret, (byte[])iv2.get(), data, DEFAULT_AES_ITERATIONS);
        }
        return SecurityIO.decryptWithAES256(secret, (byte[])iv2.get(), data, DEFAULT_AES_ITERATIONS);
    }

    @Deprecated
    public static String encryptWithAES256Base64(String secret, String iv, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SecurityIO.encryptWithAES256Base64(secret, iv, data, DEFAULT_AES_ITERATIONS);
        }
        return SecurityIO.encryptWithAES256Base64(secret, iv, data, DEFAULT_AES_ITERATIONS);
    }

    @Deprecated
    public static String decryptWithAES256Base64(String secret, String iv, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SecurityIO.decryptWithAES256Base64(secret, iv, data, DEFAULT_AES_ITERATIONS);
        }
        return SecurityIO.decryptWithAES256Base64(secret, iv, data, DEFAULT_AES_ITERATIONS);
    }

    @Deprecated
    public static String encryptWithAES256(String passphrase, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SecurityIO.encryptWithAES256(passphrase, data, DEFAULT_AES_ITERATIONS);
        }
        return SecurityIO.encryptWithAES256(passphrase, data, DEFAULT_AES_ITERATIONS);
    }

    @Deprecated
    public static String decryptWithAES256(String passphrase, String data) {
        CallSite[] callSiteArray = SecurityIO.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SecurityIO.decryptWithAES256(passphrase, data, DEFAULT_AES_ITERATIONS);
        }
        return SecurityIO.decryptWithAES256(passphrase, data, DEFAULT_AES_ITERATIONS);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        int n = 5000;
        DEFAULT_AES_ITERATIONS = n;
    }

    public static Integer getDEFAULT_AES_ITERATIONS() {
        return DEFAULT_AES_ITERATIONS;
    }

    public static void setDEFAULT_AES_ITERATIONS(Integer n) {
        DEFAULT_AES_ITERATIONS = n;
    }

    public KeyPair getKey_pair() {
        return this.key_pair;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "setKey_pair";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "encoded";
        stringArray[3] = "private";
        stringArray[4] = "getInstance";
        stringArray[5] = "getInstance";
        stringArray[6] = "initSign";
        stringArray[7] = "generatePrivate";
        stringArray[8] = "update";
        stringArray[9] = "getBytes";
        stringArray[10] = "sign";
        stringArray[11] = "encodeBase64Url";
        stringArray[12] = "getInstance";
        stringArray[13] = "initVerify";
        stringArray[14] = "public";
        stringArray[15] = "update";
        stringArray[16] = "bytes";
        stringArray[17] = "verify";
        stringArray[18] = "decodeBase64UrlBytes";
        stringArray[19] = "verify";
        stringArray[20] = "minus";
        stringArray[21] = "now";
        stringArray[22] = "ofSeconds";
        stringArray[23] = "plus";
        stringArray[24] = "ofMinutes";
        stringArray[25] = "toString";
        stringArray[26] = "getEpochSecond";
        stringArray[27] = "getEpochSecond";
        stringArray[28] = "with";
        stringArray[29] = "encodeBase64Url";
        stringArray[30] = "encodeBase64Url";
        stringArray[31] = "with";
        stringArray[32] = "tokenize";
        stringArray[33] = "size";
        stringArray[34] = "loadYamlFrom";
        stringArray[35] = "decodeBase64UrlBytes";
        stringArray[36] = "getAt";
        stringArray[37] = "alg";
        stringArray[38] = "join";
        stringArray[39] = "getAt";
        stringArray[40] = "getAt";
        stringArray[41] = "verifyRS256Base64Url";
        stringArray[42] = "verifyJsonWebToken";
        stringArray[43] = "loadYamlFrom";
        stringArray[44] = "decodeBase64UrlBytes";
        stringArray[45] = "getAt";
        stringArray[46] = "tokenize";
        stringArray[47] = "plus";
        stringArray[48] = "getEpochSecond";
        stringArray[49] = "now";
        stringArray[50] = "iat";
        stringArray[51] = "exp";
        stringArray[52] = "iat";
        stringArray[53] = "exp";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "readObject";
        stringArray[57] = "close";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "getKeypairFromPkcs8";
        stringArray[60] = "setPemKeyPair";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "class";
        stringArray[63] = "parsePrivateKey";
        stringArray[64] = "toASN1Primitive";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "writeObject";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "getEncoded";
        stringArray[70] = "close";
        stringArray[71] = "toString";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "readObject";
        stringArray[75] = "close";
        stringArray[76] = "getProvider";
        stringArray[77] = "addProvider";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "setProvider";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "getKeyPair";
        stringArray[82] = "bitLength";
        stringArray[83] = "modulus";
        stringArray[84] = "private";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "plus";
        stringArray[88] = "plus";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "bitLength";
        stringArray[91] = "modulus";
        stringArray[92] = "private";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "decodeBase64";
        stringArray[95] = "trim";
        stringArray[96] = "decodeBase64";
        stringArray[97] = "trim";
        stringArray[98] = "decodeBase64String";
        stringArray[99] = "tr";
        stringArray[100] = "decodeBase64Bytes";
        stringArray[101] = "tr";
        stringArray[102] = "toString";
        stringArray[103] = "encodeBase64";
        stringArray[104] = "bytes";
        stringArray[105] = "toString";
        stringArray[106] = "encodeBase64";
        stringArray[107] = "tr";
        stringArray[108] = "encodeBase64";
        stringArray[109] = "tr";
        stringArray[110] = "tr";
        stringArray[111] = "encodeBase64";
        stringArray[112] = "tr";
        stringArray[113] = "rsaEncryptBytesOaep";
        stringArray[114] = "bytes";
        stringArray[115] = "encodeBase64";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "<$constructor$>";
        stringArray[119] = "init";
        stringArray[120] = "createKey";
        stringArray[121] = "encoded";
        stringArray[122] = "public";
        stringArray[123] = "processBlock";
        stringArray[124] = "length";
        stringArray[125] = "decodeBase64Bytes";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "rsaDecryptBytesOaep";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "<$constructor$>";
        stringArray[132] = "init";
        stringArray[133] = "createKey";
        stringArray[134] = "encoded";
        stringArray[135] = "private";
        stringArray[136] = "processBlock";
        stringArray[137] = "length";
        stringArray[138] = "rsaEncryptBytes";
        stringArray[139] = "bytes";
        stringArray[140] = "encodeBase64";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "<$constructor$>";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "init";
        stringArray[145] = "createKey";
        stringArray[146] = "encoded";
        stringArray[147] = "public";
        stringArray[148] = "processBlock";
        stringArray[149] = "length";
        stringArray[150] = "decodeBase64Bytes";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "rsaDecryptBytes";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "<$constructor$>";
        stringArray[156] = "<$constructor$>";
        stringArray[157] = "init";
        stringArray[158] = "createKey";
        stringArray[159] = "encoded";
        stringArray[160] = "private";
        stringArray[161] = "processBlock";
        stringArray[162] = "length";
        stringArray[163] = "keySet";
        stringArray[164] = "nextInt";
        stringArray[165] = "getInstance";
        stringArray[166] = "multiply";
        stringArray[167] = "toEpochMilli";
        stringArray[168] = "now";
        stringArray[169] = "call";
        stringArray[170] = "minus";
        stringArray[171] = "minus";
        stringArray[172] = "toEpochMilli";
        stringArray[173] = "now";
        stringArray[174] = "sleep";
        stringArray[175] = "sha256Sum";
        stringArray[176] = "bytes";
        stringArray[177] = "getInstance";
        stringArray[178] = "update";
        stringArray[179] = "padLeft";
        stringArray[180] = "toString";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "digest";
        stringArray[183] = "getInstance";
        stringArray[184] = "nextBytes";
        stringArray[185] = "encodeBase64";
        stringArray[186] = "randomBytes";
        stringArray[187] = "randomBytes";
        stringArray[188] = "<$constructor$>";
        stringArray[189] = "padForAES256";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "getInstance";
        stringArray[192] = "<$constructor$>";
        stringArray[193] = "init";
        stringArray[194] = "ENCRYPT_MODE";
        stringArray[195] = "doFinal";
        stringArray[196] = "getBytes";
        stringArray[197] = "<$constructor$>";
        stringArray[198] = "write";
        stringArray[199] = "write";
        stringArray[200] = "toByteArray";
        stringArray[201] = "length";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "copyOfRange";
        stringArray[204] = "copyOfRange";
        stringArray[205] = "length";
        stringArray[206] = "<$constructor$>";
        stringArray[207] = "padForAES256";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "getInstance";
        stringArray[210] = "<$constructor$>";
        stringArray[211] = "init";
        stringArray[212] = "DECRYPT_MODE";
        stringArray[213] = "<$constructor$>";
        stringArray[214] = "doFinal";
        stringArray[215] = "decodeBase64Bytes";
        stringArray[216] = "encodeBase64";
        stringArray[217] = "encryptWithAES256GCM";
        stringArray[218] = "decodeBase64Bytes";
        stringArray[219] = "decodeBase64Bytes";
        stringArray[220] = "decryptWithAES256GCM";
        stringArray[221] = "minus";
        stringArray[222] = "sha256Sum";
        stringArray[223] = "times";
        stringArray[224] = "getAt";
        stringArray[225] = "passwordKeyDerivation";
        stringArray[226] = "getAt";
        stringArray[227] = "<$constructor$>";
        stringArray[228] = "padForAES256";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "getInstance";
        stringArray[231] = "init";
        stringArray[232] = "ENCRYPT_MODE";
        stringArray[233] = "<$constructor$>";
        stringArray[234] = "doFinal";
        stringArray[235] = "getBytes";
        stringArray[236] = "minus";
        stringArray[237] = "sha256Sum";
        stringArray[238] = "times";
        stringArray[239] = "getAt";
        stringArray[240] = "passwordKeyDerivation";
        stringArray[241] = "getAt";
        stringArray[242] = "<$constructor$>";
        stringArray[243] = "padForAES256";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "getInstance";
        stringArray[246] = "init";
        stringArray[247] = "DECRYPT_MODE";
        stringArray[248] = "<$constructor$>";
        stringArray[249] = "<$constructor$>";
        stringArray[250] = "doFinal";
        stringArray[251] = "decodeBase64Bytes";
        stringArray[252] = "decodeBase64Bytes";
        stringArray[253] = "encodeBase64";
        stringArray[254] = "encryptWithAES256";
        stringArray[255] = "decodeBase64Bytes";
        stringArray[256] = "decodeBase64Bytes";
        stringArray[257] = "decodeBase64Bytes";
        stringArray[258] = "decryptWithAES256";
        stringArray[259] = "size";
        stringArray[260] = "plus";
        stringArray[261] = "div";
        stringArray[262] = "plus";
        stringArray[263] = "size";
        stringArray[264] = "times";
        stringArray[265] = "getAt";
        stringArray[266] = "flatten";
        stringArray[267] = "abs";
        stringArray[268] = "sum";
        stringArray[269] = "collect";
        stringArray[270] = "each";
        stringArray[271] = "toList";
        stringArray[272] = "max";
        stringArray[273] = "iterationDerivation";
        stringArray[274] = "getInstance";
        stringArray[275] = "<$constructor$>";
        stringArray[276] = "toCharArray";
        stringArray[277] = "getBytes";
        stringArray[278] = "getEncoded";
        stringArray[279] = "generateSecret";
        stringArray[280] = "randomBytes";
        stringArray[281] = "encodeBase64";
        stringArray[282] = "passwordKeyDerivation";
        stringArray[283] = "encryptWithAES256GCM";
        stringArray[284] = "<$constructor$>";
        stringArray[285] = "write";
        stringArray[286] = "write";
        stringArray[287] = "encodeBase64";
        stringArray[288] = "toByteArray";
        stringArray[289] = "decodeBase64Bytes";
        stringArray[290] = "length";
        stringArray[291] = "<$constructor$>";
        stringArray[292] = "copyOfRange";
        stringArray[293] = "copyOfRange";
        stringArray[294] = "length";
        stringArray[295] = "encodeBase64";
        stringArray[296] = "passwordKeyDerivation";
        stringArray[297] = "decryptWithAES256GCM";
        stringArray[298] = "toLowerCase";
        stringArray[299] = "sha256Sum";
        stringArray[300] = "toLowerCase";
        stringArray[301] = "passwordKeyDerivation";
        stringArray[302] = "getBytes";
        stringArray[303] = "substring";
        stringArray[304] = "encodeBase64";
        stringArray[305] = "encryptWithAES256";
        stringArray[306] = "toLowerCase";
        stringArray[307] = "sha256Sum";
        stringArray[308] = "toLowerCase";
        stringArray[309] = "passwordKeyDerivation";
        stringArray[310] = "getBytes";
        stringArray[311] = "substring";
        stringArray[312] = "decodeBase64Bytes";
        stringArray[313] = "decryptWithAES256";
        stringArray[314] = "size";
        stringArray[315] = "trim";
        stringArray[316] = "trim";
        stringArray[317] = "join";
        stringArray[318] = "tokenize";
        stringArray[319] = "size";
        stringArray[320] = "mod";
        stringArray[321] = "size";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[322];
        SecurityIO.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SecurityIO.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SecurityIO.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

