/*
 * Decompiled with CFR 0.152.
 */
package net.gleske.scmfilter.impl.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Selection;
import net.gleske.scmfilter.impl.trait.Messages;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class WildcardSCMOriginFilterTrait
extends SCMSourceTrait {
    @NonNull
    private final String includes;
    @NonNull
    private final String excludes;
    @NonNull
    private final String tagIncludes;
    @NonNull
    private final String tagExcludes;

    @DataBoundConstructor
    public WildcardSCMOriginFilterTrait(@CheckForNull String includes, String excludes, String tagIncludes, String tagExcludes) {
        this.includes = (String)StringUtils.defaultIfBlank((CharSequence)includes, (CharSequence)"*");
        this.excludes = (String)StringUtils.defaultIfBlank((CharSequence)excludes, (CharSequence)"");
        this.tagIncludes = (String)StringUtils.defaultIfBlank((CharSequence)tagIncludes, (CharSequence)"");
        this.tagExcludes = (String)StringUtils.defaultIfBlank((CharSequence)tagExcludes, (CharSequence)"");
    }

    @Deprecated
    public WildcardSCMOriginFilterTrait(@CheckForNull String includes, String excludes) {
        this.includes = (String)StringUtils.defaultIfBlank((CharSequence)includes, (CharSequence)"*");
        this.excludes = (String)StringUtils.defaultIfBlank((CharSequence)excludes, (CharSequence)"");
        this.tagIncludes = "";
        this.tagExcludes = "*";
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getTagIncludes() {
        return this.tagIncludes;
    }

    public String getTagExcludes() {
        return this.tagExcludes;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        context.withPrefilter(new SCMHeadPrefilter(){

            public boolean isExcluded(@NonNull SCMSource request, @NonNull SCMHead head) {
                if (head instanceof ChangeRequestSCMHead2) {
                    String origin = ((ChangeRequestSCMHead2)head).getOriginName();
                    return !Pattern.matches(WildcardSCMOriginFilterTrait.this.getPattern(WildcardSCMOriginFilterTrait.this.getIncludes()), origin) || Pattern.matches(WildcardSCMOriginFilterTrait.this.getPattern(WildcardSCMOriginFilterTrait.this.getExcludes()), origin);
                }
                if (head instanceof TagSCMHead) {
                    return !Pattern.matches(WildcardSCMOriginFilterTrait.this.getPattern(WildcardSCMOriginFilterTrait.this.getTagIncludes()), head.getName()) || Pattern.matches(WildcardSCMOriginFilterTrait.this.getPattern(WildcardSCMOriginFilterTrait.this.getTagExcludes()), head.getName());
                }
                return !Pattern.matches(WildcardSCMOriginFilterTrait.this.getPattern(WildcardSCMOriginFilterTrait.this.getIncludes()), head.getName()) || Pattern.matches(WildcardSCMOriginFilterTrait.this.getPattern(WildcardSCMOriginFilterTrait.this.getExcludes()), head.getName());
            }
        });
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    @Symbol(value={"headWildcardFilterWithPRFromOrigin"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.WildcardSCMOriginFilterTrait_DisplayName();
        }
    }
}

