/*
 * Decompiled with CFR 0.152.
 */
package net.gleske.scmfilter.impl.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Selection;
import net.gleske.scmfilter.impl.trait.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RegexSCMOriginFilterTrait
extends SCMSourceTrait {
    @NonNull
    private final String regex;
    @NonNull
    private final String tagRegex;
    @CheckForNull
    private transient Pattern pattern;
    @CheckForNull
    private transient Pattern tagPattern;

    @DataBoundConstructor
    public RegexSCMOriginFilterTrait(@NonNull String regex, @NonNull String tagRegex) {
        this.pattern = Pattern.compile(regex);
        this.regex = regex;
        this.tagPattern = Pattern.compile(tagRegex);
        this.tagRegex = tagRegex;
    }

    @Deprecated
    public RegexSCMOriginFilterTrait(@NonNull String regex) {
        this.pattern = Pattern.compile(regex);
        this.regex = regex;
        this.tagPattern = Pattern.compile("(?!.*)");
        this.tagRegex = "(?!.*)";
    }

    @NonNull
    public String getRegex() {
        return this.regex;
    }

    @NonNull
    public String getTagRegex() {
        return this.tagRegex;
    }

    @NonNull
    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        return this.pattern;
    }

    @NonNull
    private Pattern getTagPattern() {
        if (this.tagPattern == null) {
            this.tagPattern = Pattern.compile(this.tagRegex);
        }
        return this.tagPattern;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        context.withPrefilter(new SCMHeadPrefilter(){

            public boolean isExcluded(@NonNull SCMSource source, @NonNull SCMHead head) {
                if (head instanceof ChangeRequestSCMHead2) {
                    String origin = ((ChangeRequestSCMHead2)head).getOriginName();
                    return !RegexSCMOriginFilterTrait.this.getPattern().matcher(origin).matches();
                }
                if (head instanceof TagSCMHead) {
                    return !RegexSCMOriginFilterTrait.this.getTagPattern().matcher(head.getName()).matches();
                }
                return !RegexSCMOriginFilterTrait.this.getPattern().matcher(head.getName()).matches();
            }
        });
    }

    @Symbol(value={"headRegexFilterWithPRFromOrigin"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.RegexSCMOriginFilterTrait_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRegex(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

