/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.form;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="On purpose ignoring 'name' field, not changing current behavior present since ~2 years")
public class NamedArrayList<E>
extends ArrayList<E> {
    @NonNull
    private final String name;

    public NamedArrayList(@NonNull String name, Collection<? extends E> c) {
        super(c);
        this.name = name;
    }

    public NamedArrayList(@NonNull String name, E ... elements) {
        super(Arrays.asList(elements));
        this.name = name;
    }

    @NonNull
    public final String getName() {
        return this.name;
    }

    public static <E> void select(@NonNull List<? extends E> source, @NonNull String name, @CheckForNull Predicate<? super E> selector, boolean removeSelectedFromSource, @NonNull List<NamedArrayList<? extends E>> destination) {
        NamedArrayList.select(source, name, selector, removeSelectedFromSource, destination, Integer.MAX_VALUE);
    }

    public static <E> void select(@NonNull List<? extends E> source, @NonNull String name, @CheckForNull Predicate<? super E> selector, boolean removeSelectedFromSource, @NonNull List<NamedArrayList<? extends E>> destination, int index) {
        NamedArrayList<Object> selection = new NamedArrayList<Object>(name, new Object[0]);
        if (selector == null) {
            selection.addAll(source);
            if (removeSelectedFromSource) {
                source.clear();
            }
        } else {
            Iterator<E> iterator = source.iterator();
            while (iterator.hasNext()) {
                E candidate = iterator.next();
                if (!selector.test(candidate)) continue;
                selection.add(candidate);
                if (!removeSelectedFromSource) continue;
                iterator.remove();
            }
        }
        if (!selection.isEmpty()) {
            destination.add(Math.min(destination.size(), Math.max(index, 0)), selection);
        }
    }

    public static <E> Predicate<E> allOf(final Predicate<? super E> ... predicates) {
        if (predicates.length < 2) {
            throw new IllegalArgumentException("Must supply at least two predicates");
        }
        return new Predicate<E>(){

            @Override
            public boolean test(E e) {
                for (Predicate p : predicates) {
                    if (p.test(e)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <E> Predicate<E> anyOf(final Predicate<E> ... predicates) {
        if (predicates.length < 2) {
            throw new IllegalArgumentException("Must supply at least two predicates");
        }
        return new Predicate<E>(){

            @Override
            public boolean test(E e) {
                for (Predicate p : predicates) {
                    if (!p.test(e)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <A extends Annotation> Predicate<Object> withAnnotation(final Class<A> annotation) {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                return o.getClass().getAnnotation(annotation) != null;
            }
        };
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

