/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import java.util.ArrayList;
import java.util.List;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.api.trait.SCMTrait;

public abstract class SCMSourceTrait
extends SCMTrait<SCMSourceTrait> {
    public final void applyToContext(SCMSourceContext<?, ?> context) {
        SCMSourceTraitDescriptor d = this.getDescriptor();
        if (d.getContextClass().isInstance(context) && d.isApplicableToContext(context.getClass())) {
            this.decorateContext(context);
        }
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
    }

    @NonNull
    public final SCMHeadObserver applyToObserver(@NonNull SCMHeadObserver observer) {
        return this.decorateObserver(observer);
    }

    @NonNull
    protected SCMHeadObserver decorateObserver(@NonNull SCMHeadObserver observer) {
        return observer;
    }

    public final void applyToBuilder(SCMBuilder<?, ?> builder) {
        SCMSourceTraitDescriptor d = this.getDescriptor();
        if (d.getBuilderClass().isInstance(builder) && d.isApplicableToBuilder(builder)) {
            this.decorateBuilder(builder);
        }
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
    }

    public final boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        return this.includeCategory(category);
    }

    protected boolean includeCategory(@NonNull SCMHeadCategory category) {
        return false;
    }

    @Override
    public SCMSourceTraitDescriptor getDescriptor() {
        return (SCMSourceTraitDescriptor)super.getDescriptor();
    }

    public static DescriptorExtensionList<SCMSourceTrait, SCMSourceTraitDescriptor> all() {
        return SCMTrait.all(SCMSourceTrait.class);
    }

    public static List<SCMSourceTraitDescriptor> _for(@CheckForNull Class<? extends SCMSourceContext> contextClass, @CheckForNull Class<? extends SCMBuilder> builderClass) {
        return SCMSourceTrait._for(null, contextClass, builderClass);
    }

    public static List<SCMSourceTraitDescriptor> _for(@CheckForNull SCMSourceDescriptor scmSource, @CheckForNull Class<? extends SCMSourceContext> contextClass, @CheckForNull Class<? extends SCMBuilder> builderClass) {
        ArrayList<SCMSourceTraitDescriptor> result = new ArrayList<SCMSourceTraitDescriptor>();
        if (scmSource != null) {
            for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                if (contextClass != null && !d.isApplicableToContext(contextClass) || builderClass != null && !d.isApplicableToBuilder(builderClass) || !d.isApplicableTo(scmSource)) continue;
                result.add(d);
            }
        } else {
            for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                if (contextClass != null && !d.isApplicableToContext(contextClass) || builderClass != null && !d.isApplicableToBuilder(builderClass)) continue;
                result.add(d);
            }
        }
        return result;
    }
}

