/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;

public abstract class SCMFileSystem
implements Closeable {
    @CheckForNull
    private final SCMRevision rev;

    protected SCMFileSystem(@CheckForNull SCMRevision rev) {
        this.rev = rev;
    }

    @Override
    public void close() throws IOException {
    }

    public abstract long lastModified() throws IOException, InterruptedException;

    @CheckForNull
    public SCMRevision getRevision() {
        return this.rev;
    }

    public final boolean isFixedRevision() {
        return this.getRevision() != null;
    }

    @NonNull
    public final SCMFile child(@NonNull String path) {
        return this.getRoot().child(path);
    }

    @NonNull
    public abstract SCMFile getRoot();

    public boolean changesSince(@CheckForNull SCMRevision revision, @NonNull OutputStream changeLogStream) throws UnsupportedOperationException, IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull Item owner, @NonNull SCM scm) throws IOException, InterruptedException {
        return SCMFileSystem.of(owner, scm, null);
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        return SCMFileSystem.of(owner, scm, rev, null);
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev, @CheckForNull Run<?, ?> build) throws IOException, InterruptedException {
        Objects.requireNonNull(scm);
        SCMFileSystem fallBack = null;
        Exception failure = null;
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            if (!b.supports(scm)) continue;
            try {
                SCMFileSystem inspector = b.build(owner, scm, rev, build);
                if (inspector == null) continue;
                if (inspector.isFixedRevision()) {
                    return inspector;
                }
                if (fallBack != null) continue;
                fallBack = inspector;
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                if (failure == null) {
                    failure = e;
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (fallBack == null) {
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            if (failure instanceof InterruptedException) {
                throw (InterruptedException)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
        }
        return fallBack;
    }

    public static boolean supports(@NonNull SCM scm) {
        Objects.requireNonNull(scm);
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            if (!b.supports(scm)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull SCMSource source, @NonNull SCMHead head) throws IOException, InterruptedException {
        return SCMFileSystem.of(source, head, null);
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        Objects.requireNonNull(source);
        SCMFileSystem fallBack = null;
        Exception failure = null;
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            if (!b.supports(source)) continue;
            try {
                SCMFileSystem inspector = b.build(source, head, rev);
                if (inspector == null) continue;
                if (inspector.isFixedRevision()) {
                    return inspector;
                }
                if (fallBack != null) continue;
                fallBack = inspector;
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                if (failure == null) {
                    failure = e;
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (fallBack == null) {
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            if (failure instanceof InterruptedException) {
                throw (InterruptedException)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
        }
        return fallBack;
    }

    public static boolean supports(@NonNull SCMSource source) {
        Objects.requireNonNull(source);
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            if (!b.supports(source)) continue;
            return true;
        }
        return false;
    }

    public static boolean supports(@NonNull SCMDescriptor descriptor) {
        Objects.requireNonNull(descriptor);
        if (descriptor.clazz == null) {
            throw new NullPointerException();
        }
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            if (!b.supports(descriptor)) continue;
            return true;
        }
        return false;
    }

    public static boolean supports(@NonNull SCMSourceDescriptor descriptor) {
        Objects.requireNonNull(descriptor);
        if (descriptor.clazz == null) {
            throw new NullPointerException();
        }
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            if (!b.supports(descriptor)) continue;
            return true;
        }
        return false;
    }

    public static abstract class Builder
    implements ExtensionPoint {
        public abstract boolean supports(SCM var1);

        public abstract boolean supports(SCMSource var1);

        public final boolean supports(SCMDescriptor<?> descriptor) {
            if (Util.isOverridden(Builder.class, this.getClass(), (String)"supportsDescriptor", (Class[])new Class[]{SCMDescriptor.class})) {
                return this.supportsDescriptor(descriptor);
            }
            return this.isEnclosedByDescribable((Descriptor<?>)descriptor) || this.getClass().getPackage().equals(descriptor.clazz.getPackage()) || this.getClass().getPackage().getName().startsWith(descriptor.clazz.getPackage().getName());
        }

        protected abstract boolean supportsDescriptor(SCMDescriptor var1);

        public final boolean supports(SCMSourceDescriptor descriptor) {
            if (Util.isOverridden(Builder.class, this.getClass(), (String)"supportsDescriptor", (Class[])new Class[]{SCMSourceDescriptor.class})) {
                return this.supportsDescriptor(descriptor);
            }
            return this.isEnclosedByDescribable(descriptor) || this.getClass().getPackage().equals(descriptor.clazz.getPackage()) || this.getClass().getPackage().getName().startsWith(descriptor.clazz.getPackage().getName());
        }

        protected abstract boolean supportsDescriptor(SCMSourceDescriptor var1);

        @CheckForNull
        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            throw new AbstractMethodError("Implement build(Item, SCM, SCMRevision, Run) and override this method to delegate to it");
        }

        @CheckForNull
        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            SCMSourceOwner owner = source.getOwner();
            if (owner == null) {
                throw new IOException("Cannot instantiate a SCMFileSystem from an SCM without an owner");
            }
            return this.build(owner, source.build(head, rev), rev, null);
        }

        private boolean isEnclosedByDescribable(Descriptor<?> descriptor) {
            Class<?> enclosingClass = this.getClass().getEnclosingClass();
            return enclosingClass != null && descriptor.clazz.isAssignableFrom(enclosingClass);
        }

        @CheckForNull
        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev, @CheckForNull Run<?, ?> _build) throws IOException, InterruptedException {
            return this.build(owner, scm, rev);
        }
    }
}

