/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;

public final class SCMUri {
    private static final Map<String, Integer> commonDefaultPorts = Map.of("ftp", 21, "ssh", 22, "telnet", 22, "http", 80, "https", 443);

    private SCMUri() {
        throw new IllegalAccessError("Utility class");
    }

    public static Map<String, Integer> commonDefaultPorts() {
        return commonDefaultPorts;
    }

    @CheckForNull
    public static String normalize(@CheckForNull String uri) {
        return SCMUri.normalize(uri, commonDefaultPorts);
    }

    @CheckForNull
    public static String normalize(@CheckForNull String uri, Map<String, Integer> ... defaultPorts) {
        if (uri == null) {
            return null;
        }
        try {
            Map<String, Integer> ports;
            URI u = new URI(uri).normalize();
            String scheme = u.getScheme().toLowerCase(Locale.ENGLISH);
            Integer defaultPort = null;
            Map<String, Integer>[] mapArray = defaultPorts;
            int n = mapArray.length;
            for (int i = 0; i < n && (defaultPort = (ports = mapArray[i]).get(scheme)) == null; ++i) {
            }
            if (defaultPort != null) {
                host = u.getHost();
                if (host != null) {
                    host = host.toLowerCase(Locale.ENGLISH);
                    int port = u.getPort();
                    uri = new URI(scheme, u.getUserInfo(), host, port == defaultPort ? -1 : port, u.getPath(), u.getQuery(), u.getFragment()).toASCIIString();
                } else {
                    Object authority = u.getAuthority();
                    if (authority != null) {
                        String portPart;
                        String portSep;
                        String userSep;
                        String userPart;
                        int at = ((String)authority).indexOf(64);
                        int colon = ((String)authority).lastIndexOf(58);
                        if (colon != -1 && at > colon) {
                            colon = -1;
                        }
                        if (colon != -1) {
                            for (int i = colon + 1; i < ((String)authority).length(); ++i) {
                                if (Character.isDigit(((String)authority).codePointAt(i))) continue;
                                colon = -1;
                                break;
                            }
                        }
                        if (at == -1) {
                            userPart = "";
                            userSep = "";
                        } else {
                            userPart = ((String)authority).substring(0, at);
                            userSep = "@";
                        }
                        if (colon == -1) {
                            portSep = "";
                            portPart = "";
                        } else {
                            int port = Integer.parseInt(((String)authority).substring(colon + 1));
                            if (port != defaultPort) {
                                portSep = ":";
                                portPart = Integer.toString(port);
                            } else {
                                portSep = "";
                                portPart = "";
                            }
                        }
                        String hostPart = IDN.toASCII(((String)authority).substring(at + 1, colon == -1 ? ((String)authority).length() : colon)).toLowerCase(Locale.ENGLISH);
                        authority = userPart + userSep + hostPart + portSep + portPart;
                    }
                    uri = new URI(scheme, (String)authority, u.getPath(), u.getQuery(), u.getFragment()).toASCIIString();
                }
            } else {
                host = u.getHost();
                if (u.getHost() != null) {
                    host = host.toLowerCase(Locale.ENGLISH);
                    uri = new URI(scheme, u.getUserInfo(), host, u.getPort(), u.getPath(), u.getQuery(), u.getFragment()).toASCIIString();
                } else {
                    uri = new URI(scheme, u.getSchemeSpecificPart(), u.getFragment()).toASCIIString();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri.replaceAll("/$", "");
    }
}

