/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import hudson.DescriptorExtensionList;
import hudson.model.AbstractDescribableImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.SCMHeadMixin;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMSourceRequest;

public abstract class SCMHeadAuthority<S extends SCMSourceRequest, H extends SCMHeadMixin, R extends SCMRevision>
extends AbstractDescribableImpl<SCMHeadAuthority<?, ?, ?>> {
    public final boolean isApplicableTo(@NonNull SCMHead head) {
        return this.getDescriptor().isApplicableToHead(head);
    }

    public final boolean isApplicableTo(@NonNull SCMRevision revision) {
        return this.getDescriptor().isApplicableToRevision(revision);
    }

    public final boolean isApplicableTo(@NonNull SCMSourceRequest request) {
        return this.getDescriptor().isApplicableToRequest(request);
    }

    public final boolean isTrusted(@NonNull SCMSourceRequest request, @NonNull SCMHead head) throws IOException, InterruptedException {
        return this.isApplicableTo(request) && this.isApplicableTo(head) && this.checkTrusted((S)request, (R)head);
    }

    public final boolean isTrusted(@NonNull SCMSourceRequest request, @CheckForNull SCMRevision revision) throws IOException, InterruptedException {
        return this.isApplicableTo(request) && this.isApplicableTo(revision.getHead()) && this.isApplicableTo(revision) && this.checkTrusted((S)request, (R)revision);
    }

    protected abstract boolean checkTrusted(@NonNull S var1, @NonNull H var2) throws IOException, InterruptedException;

    @OverrideMustInvoke
    protected boolean checkTrusted(@NonNull S request, @NonNull R revision) throws IOException, InterruptedException {
        return this.checkTrusted(request, (R)((SCMRevision)revision).getHead());
    }

    public SCMHeadAuthorityDescriptor getDescriptor() {
        return (SCMHeadAuthorityDescriptor)super.getDescriptor();
    }

    public static DescriptorExtensionList<SCMHeadAuthority<?, ?, ?>, SCMHeadAuthorityDescriptor> all() {
        return Jenkins.get().getDescriptorList(SCMHeadAuthority.class);
    }

    public static List<SCMHeadAuthorityDescriptor> _for(@CheckForNull Class<? extends SCMSourceRequest> requestClass, @CheckForNull Class<? extends SCMHeadMixin> headClass, @CheckForNull Class<? extends SCMRevision> revisionClass, Class<? extends SCMHeadOrigin> ... origins) {
        if (requestClass == null) {
            requestClass = SCMSourceRequest.class;
        }
        if (headClass == null) {
            headClass = SCMHeadMixin.class;
        }
        if (revisionClass == null) {
            revisionClass = SCMRevision.class;
        }
        ArrayList<SCMHeadAuthorityDescriptor> result = new ArrayList<SCMHeadAuthorityDescriptor>();
        for (SCMHeadAuthorityDescriptor d : SCMHeadAuthority.all()) {
            boolean match;
            if (!d.isApplicableToRequest(requestClass) || !d.isApplicableToHead(headClass) || !d.isApplicableToRevision(revisionClass)) continue;
            boolean bl = match = origins.length == 0;
            if (!match) {
                for (Class<? extends SCMHeadOrigin> o : origins) {
                    if (!d.isApplicableToOrigin(o)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            result.add(d);
        }
        return result;
    }
}

