/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.metadata;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.InvisibleAction;
import java.io.Serializable;
import jenkins.model.Jenkins;
import jenkins.scm.impl.avatars.AvatarCache;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.lang3.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AvatarMetadataAction
extends InvisibleAction
implements Serializable {
    private static final long serialVersionUID = 1L;

    @CheckForNull
    public String getAvatarIconClassName() {
        return null;
    }

    @CheckForNull
    public String getAvatarDescription() {
        return null;
    }

    @CheckForNull
    public String getAvatarImageOf(@NonNull String size) {
        return this.avatarIconClassNameImageOf(this.getAvatarIconClassName(), size);
    }

    @CheckForNull
    protected final String avatarIconClassNameImageOf(@CheckForNull String iconClassName, @NonNull String size) {
        if (StringUtils.isNotBlank((CharSequence)iconClassName)) {
            Icon icon;
            String spec = null;
            switch (size) {
                case "16x16": {
                    spec = "icon-sm";
                    break;
                }
                case "24x24": {
                    spec = "icon-md";
                    break;
                }
                case "32x32": {
                    spec = "icon-lg";
                    break;
                }
                case "48x48": {
                    spec = "icon-xlg";
                    break;
                }
            }
            if (spec != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " " + spec))) != null) {
                JellyContext ctx = new JellyContext();
                StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
                if (currentRequest == null) {
                    throw new IllegalStateException("cannot call avatarIconClassNameImageOf from outside a request handling thread");
                }
                ctx.setVariable("resURL", (Object)(currentRequest.getContextPath() + Jenkins.RESOURCE_PATH));
                return icon.getQualifiedUrl(ctx);
            }
        }
        return null;
    }

    @NonNull
    protected final String cachedResizedImageOf(@NonNull String url, @NonNull String size) {
        return AvatarCache.buildUrl(url, size);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

