/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.schedulebuild;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.schedulebuild.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"scheduleBuild"})
public class ScheduleBuildGlobalConfiguration
extends GlobalConfiguration {
    private transient Date defaultScheduleTime;
    private String timeZone = TimeZone.getDefault().getID();
    private String defaultStartTime = "22:00:00";
    private transient LocalTime defaultScheduleLocalTime;
    private static final Logger LOGGER = Logger.getLogger(ScheduleBuildGlobalConfiguration.class.getName());
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateTimeFormatter[] FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("H:m[:s]"), DateTimeFormatter.ofPattern("h:m[:s] a", Locale.ROOT)};

    public static ScheduleBuildGlobalConfiguration get() {
        ScheduleBuildGlobalConfiguration configuration = (ScheduleBuildGlobalConfiguration)((Object)GlobalConfiguration.all().get(ScheduleBuildGlobalConfiguration.class));
        if (configuration == null) {
            throw new IllegalStateException("[BUG] No configuration registered, make sure not running on an agent or that Jenkins has started properly.");
        }
        return configuration;
    }

    @DataBoundConstructor
    public ScheduleBuildGlobalConfiguration() {
        this.load();
        this.defaultScheduleLocalTime = LocalTime.parse(this.defaultStartTime, this.getTimeFormatter());
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Written by xstream")
    public void load() {
        super.load();
        if (this.defaultScheduleTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(TIME_PATTERN);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.setDefaultStartTime(sdf.format(this.defaultScheduleTime));
        }
    }

    public String getDefaultScheduleTime() {
        return this.getDefaultStartTime();
    }

    public String getDefaultStartTime() {
        return this.defaultStartTime;
    }

    @DataBoundSetter
    public void setDefaultStartTime(String defaultStartTime) {
        this.defaultScheduleLocalTime = this.parseTime(defaultStartTime);
        this.defaultStartTime = this.defaultScheduleLocalTime.format(this.getTimeFormatter());
        this.save();
    }

    @DataBoundSetter
    public void setDefaultScheduleTime(String defaultScheduleTime) throws ParseException {
        this.setDefaultStartTime(defaultScheduleTime);
    }

    private LocalTime parseTime(String time) {
        DateTimeParseException exception = null;
        String ftime = time.trim();
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalTime.parse(ftime.toUpperCase(Locale.ROOT), formatter);
            }
            catch (DateTimeParseException dtex) {
                exception = dtex;
                LOGGER.log(Level.FINE, dtex, () -> "Did not parse '" + ftime + "' with formatter " + String.valueOf(formatter));
            }
        }
        throw exception;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @DataBoundSetter
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        this.save();
    }

    public ZoneId getZoneId() {
        try {
            return ZoneId.of(this.timeZone);
        }
        catch (DateTimeException dte) {
            return ZoneId.systemDefault();
        }
    }

    private DateTimeFormatter getTimeFormatter() {
        return DateTimeFormatter.ofPattern(TIME_PATTERN);
    }

    public ZonedDateTime getDefaultScheduleTimeObject() {
        ZonedDateTime zdt = this.defaultScheduleLocalTime.atDate(LocalDate.now()).atZone(this.getZoneId());
        return zdt;
    }

    @RequirePOST
    public FormValidation doCheckDefaultStartTime(@QueryParameter String value) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            this.parseTime(value);
        }
        catch (DateTimeParseException ex) {
            return FormValidation.error((String)Messages.ScheduleBuildGlobalConfiguration_ParsingError());
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doCheckTimeZone(@QueryParameter String value) {
        Jenkins.get().checkAnyPermission(new Permission[]{Jenkins.ADMINISTER, Jenkins.SYSTEM_READ});
        ZoneId zone = ZoneId.of(value);
        if (Objects.equals(zone.getId(), value)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.ScheduleBuildGlobalConfiguration_TimeZoneError());
    }

    @POST
    public ListBoxModel doFillTimeZoneItems() {
        Jenkins.get().checkAnyPermission(new Permission[]{Jenkins.ADMINISTER, Jenkins.SYSTEM_READ});
        ListBoxModel items = new ListBoxModel();
        TreeSet<String> zoneIds = new TreeSet<String>(ZoneId.getAvailableZoneIds());
        for (String id : zoneIds) {
            if (id.equalsIgnoreCase(this.timeZone)) {
                items.add((Object)new ListBoxModel.Option(id, id, true));
                continue;
            }
            items.add(id);
        }
        return items;
    }
}

