/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.authenticator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2AuthenticationCredentials;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.logout.impl.SAML2LogoutValidator;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.profile.SAML2ProfileDefinition;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2Authenticator
extends ProfileDefinitionAware
implements Authenticator {
    public static final String SAML_CONDITION_NOT_BEFORE_ATTRIBUTE = "notBefore";
    public static final String SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE = "notOnOrAfter";
    public static final String SESSION_INDEX = "sessionindex";
    public static final String ISSUER_ID = "issuerId";
    public static final String AUTHN_CONTEXT = "authnContext";
    public static final String AUTHN_CONTEXT_AUTHORITIES = "authnContextAuthorities";
    public static final String SAML_NAME_ID_FORMAT = "samlNameIdFormat";
    public static final String SAML_NAME_ID_NAME_QUALIFIER = "samlNameIdNameQualifier";
    public static final String SAML_NAME_ID_SP_NAME_QUALIFIER = "samlNameIdSpNameQualifier";
    public static final String SAML_NAME_ID_SP_PROVIDED_ID = "samlNameIdSpProvidedId";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SAML2ResponseValidator loginValidator;
    private final SAML2LogoutValidator logoutValidator;
    private final String attributeAsId;
    private final Map<String, String> mappedAttributes;

    public SAML2Authenticator(SAML2ResponseValidator loginValidator, SAML2LogoutValidator logoutValidator, String attributeAsId, Map<String, String> mappedAttributes) {
        this.loginValidator = loginValidator;
        this.logoutValidator = logoutValidator;
        this.attributeAsId = attributeAsId;
        this.mappedAttributes = mappedAttributes;
    }

    public SAML2Authenticator(SAML2ResponseValidator loginValidator, SAML2LogoutValidator logoutValidator, String attributeAsId) {
        this(loginValidator, logoutValidator, attributeAsId, new HashMap<String, String>());
    }

    protected void internalInit(boolean forceReinit) {
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new SAML2ProfileDefinition());
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials extractedCredentials) {
        this.init();
        SAML2Credentials saml2Credentials = (SAML2Credentials)extractedCredentials;
        SAML2MessageContext samlContext = saml2Credentials.getContext();
        if (saml2Credentials.isForAuthentication()) {
            SAML2AuthenticationCredentials authenticationCredentials = (SAML2AuthenticationCredentials)this.loginValidator.validate(samlContext);
            this.buildProfile(authenticationCredentials);
            return Optional.of(authenticationCredentials);
        }
        this.logoutValidator.validate(samlContext);
        return Optional.of(extractedCredentials);
    }

    protected void buildProfile(SAML2AuthenticationCredentials credentials) {
        SAML2Profile profile = (SAML2Profile)this.getProfileDefinition().newProfile(new Object[0]);
        SAML2AuthenticationCredentials.SAMLNameID nameId = credentials.getNameId();
        profile.setId(nameId.getValue());
        profile.addAuthenticationAttribute(SESSION_INDEX, credentials.getSessionIndex());
        profile.addAuthenticationAttribute(SAML_NAME_ID_FORMAT, nameId.getFormat());
        profile.addAuthenticationAttribute(SAML_NAME_ID_NAME_QUALIFIER, nameId.getNameQualifier());
        profile.addAuthenticationAttribute(SAML_NAME_ID_SP_NAME_QUALIFIER, nameId.getSpNameQualifier());
        profile.addAuthenticationAttribute(SAML_NAME_ID_SP_PROVIDED_ID, nameId.getSpProviderId());
        for (SAML2AuthenticationCredentials.SAMLAttribute attribute : credentials.getAttributes()) {
            this.logger.debug("Processing profile attribute {}", (Object)attribute);
            String name = attribute.getName();
            String friendlyName = attribute.getFriendlyName();
            List<String> values = attribute.getAttributeValues();
            if (!values.isEmpty()) {
                String actualName;
                if (StringUtils.isNotBlank((CharSequence)this.attributeAsId) && (this.attributeAsId.equalsIgnoreCase(name) || this.attributeAsId.equalsIgnoreCase(friendlyName))) {
                    if (values.size() == 1) {
                        profile.setId(values.get(0));
                    } else {
                        this.logger.warn("Will not add {} as id because it has multiple values: {}", (Object)this.attributeAsId, values);
                    }
                }
                if (this.mappedAttributes != null && !this.mappedAttributes.isEmpty() && this.mappedAttributes.containsKey(name)) {
                    actualName = this.mappedAttributes.get(name);
                    this.logger.debug("Mapping attribute {} as {} with values {} to profile", new Object[]{name, actualName, values});
                    this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, actualName, values);
                } else {
                    actualName = name;
                    this.logger.debug("Adding attribute {} to profile with values {}", (Object)name, values);
                    this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, name, values);
                }
                if (!StringUtils.isNotBlank((CharSequence)friendlyName) || StringUtils.equals((CharSequence)friendlyName, (CharSequence)actualName)) continue;
                this.logger.debug("Adding attribute {} to profile with values {}", (Object)friendlyName, values);
                this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, friendlyName, values);
                continue;
            }
            this.logger.debug("No attribute values found for {}", (Object)name);
        }
        profile.addAuthenticationAttribute(ISSUER_ID, credentials.getIssuerId());
        profile.addAuthenticationAttribute(AUTHN_CONTEXT, credentials.getAuthnContexts());
        profile.addAuthenticationAttribute(AUTHN_CONTEXT_AUTHORITIES, credentials.getAuthnContextAuthorities());
        SAML2AuthenticationCredentials.SAMLConditions conditions = credentials.getConditions();
        if (conditions != null) {
            if (conditions.getNotBefore() != null) {
                profile.addAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
                profile.addAuthenticationAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
            }
            if (conditions.getNotOnOrAfter() != null) {
                profile.addAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
                profile.addAuthenticationAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
            }
        }
        credentials.setUserProfile((UserProfile)profile);
    }
}

