/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import lombok.Generated;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2ContextProvider;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.authenticator.SAML2Authenticator;
import org.pac4j.saml.credentials.extractor.SAML2CredentialsExtractor;
import org.pac4j.saml.crypto.DefaultSignatureSigningParametersProvider;
import org.pac4j.saml.crypto.ExplicitSignatureTrustEngineProvider;
import org.pac4j.saml.crypto.KeyStoreDecryptionProvider;
import org.pac4j.saml.crypto.LogOnlySignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.logout.SAML2LogoutActionBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutRequestMessageSender;
import org.pac4j.saml.logout.impl.SAML2LogoutValidator;
import org.pac4j.saml.logout.processor.SAML2LogoutProcessor;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2ServiceProviderMetadataResolver;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.redirect.SAML2RedirectionActionBuilder;
import org.pac4j.saml.replay.InMemoryReplayCacheProvider;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.sso.artifact.DefaultSOAPPipelineProvider;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.sso.impl.SAML2AuthnResponseValidator;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageSender;
import org.pac4j.saml.state.SAML2StateGenerator;
import org.pac4j.saml.util.Configuration;

public class SAML2Client
extends IndirectClient
implements Closeable {
    protected SAMLContextProvider contextProvider;
    protected SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected SAML2ResponseValidator authnResponseValidator;
    protected SAML2LogoutValidator logoutValidator;
    protected SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected SAML2MetadataResolver identityProviderMetadataResolver;
    protected SAML2MetadataResolver serviceProviderMetadataResolver;
    protected Decrypter decrypter;
    protected SAML2Configuration configuration;
    protected ValueGenerator stateGenerator;
    protected ReplayCacheProvider replayCache;
    protected SOAPPipelineProvider soapPipelineProvider;
    protected SAML2LogoutRequestMessageSender logoutRequestMessageSender;
    protected SAML2WebSSOMessageSender webSsoMessageSender;

    public SAML2Client(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        String callbackUrl = this.computeFinalCallbackUrl(null);
        this.configuration.setCallbackUrl(callbackUrl);
        this.configuration.init(forceReinit);
        this.initDecrypter(forceReinit);
        this.initSignatureSigningParametersProvider(forceReinit);
        this.initIdentityProviderMetadataResolver(forceReinit);
        this.initServiceProviderMetadataResolver(forceReinit);
        this.initSAMLContextProvider(forceReinit);
        this.initSignatureTrustEngineProvider(forceReinit);
        this.initSAMLReplayCache(forceReinit);
        this.initSAMLResponseValidator(forceReinit);
        this.initSOAPPipelineProvider(forceReinit);
        this.initSAMLLogoutResponseValidator(forceReinit);
        this.initRedirectActionBuilder(forceReinit);
        this.initCredentialExtractor(forceReinit);
        this.initAuthenticator(forceReinit);
        this.initStateGenerator(forceReinit);
        this.initWebSSOMessageSender(forceReinit);
        this.initLogoutProcessor(forceReinit);
        this.initLogoutRequestMessageSender(forceReinit);
        this.initLogoutActionBuilder(forceReinit);
    }

    protected void initStateGenerator(boolean forceReinit) {
        if (this.stateGenerator == null || forceReinit) {
            this.stateGenerator = new SAML2StateGenerator(this);
        }
    }

    protected void initWebSSOMessageSender(boolean forceReinit) {
        if (this.webSsoMessageSender == null || forceReinit) {
            this.webSsoMessageSender = new SAML2WebSSOMessageSender(this.signatureSigningParametersProvider, this.configuration.getAuthnRequestBindingType(), true, this.configuration.isAuthnRequestSigned());
        }
    }

    protected void initLogoutRequestMessageSender(boolean forceReinit) {
        if (this.logoutRequestMessageSender == null || forceReinit) {
            this.logoutRequestMessageSender = new SAML2LogoutRequestMessageSender(this.signatureSigningParametersProvider, this.configuration.getSpLogoutRequestBindingType(), false, this.configuration.isSpLogoutRequestSigned());
        }
    }

    protected void initLogoutActionBuilder(boolean forceReinit) {
        if (this.isLogoutActionBuilderUndefined() || forceReinit) {
            this.setLogoutActionBuilder(new SAML2LogoutActionBuilder(this));
        }
    }

    protected void initRedirectActionBuilder(boolean forceReinit) {
        if (this.getRedirectionActionBuilder() == null || forceReinit) {
            this.setRedirectionActionBuilderIfUndefined(new SAML2RedirectionActionBuilder(this));
        }
    }

    protected void initCredentialExtractor(boolean forceReinit) {
        if (this.getCredentialsExtractor() == null || forceReinit) {
            this.setCredentialsExtractorIfUndefined(new SAML2CredentialsExtractor(this, this.identityProviderMetadataResolver, this.serviceProviderMetadataResolver, this.soapPipelineProvider));
        }
    }

    protected void initAuthenticator(boolean forceReinit) {
        if (this.getAuthenticator() == null || forceReinit) {
            this.setAuthenticatorIfUndefined(new SAML2Authenticator(this.authnResponseValidator, this.logoutValidator, this.configuration.getAttributeAsId(), this.configuration.getMappedAttributes()));
        }
    }

    protected void initLogoutProcessor(boolean forceReinit) {
        if (this.getLogoutProcessor() == null || forceReinit) {
            this.setLogoutProcessor(new SAML2LogoutProcessor(this));
        }
    }

    protected void initSOAPPipelineProvider(boolean forceReinit) {
        if (this.soapPipelineProvider == null || forceReinit) {
            this.soapPipelineProvider = new DefaultSOAPPipelineProvider(this);
        }
    }

    protected void initSAMLLogoutResponseValidator(boolean forceReinit) {
        if (this.logoutValidator == null || forceReinit) {
            this.logoutValidator = new SAML2LogoutValidator(this.signatureTrustEngineProvider, this.decrypter, this.findSessionLogoutHandler(), this.replayCache, this.configuration.getUriComparator());
            this.logoutValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
            this.logoutValidator.setPartialLogoutTreatedAsSuccess(this.configuration.isPartialLogoutTreatedAsSuccess());
        }
    }

    protected void initSAMLResponseValidator(boolean forceReinit) {
        if (this.authnResponseValidator == null || forceReinit) {
            this.authnResponseValidator = new SAML2AuthnResponseValidator(this.signatureTrustEngineProvider, this.decrypter, this.replayCache, this.configuration, this.findSessionLogoutHandler());
            this.authnResponseValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
        }
    }

    protected void initSignatureTrustEngineProvider(boolean forceReinit) {
        if (this.signatureTrustEngineProvider == null || forceReinit) {
            this.signatureTrustEngineProvider = new ExplicitSignatureTrustEngineProvider(this.identityProviderMetadataResolver, this.serviceProviderMetadataResolver);
            if (this.configuration.isAllSignatureValidationDisabled()) {
                this.signatureTrustEngineProvider = new LogOnlySignatureTrustEngineProvider(this.signatureTrustEngineProvider);
            }
        }
    }

    protected void initSAMLContextProvider(boolean forceReinit) {
        if (this.contextProvider == null || forceReinit) {
            this.contextProvider = new SAML2ContextProvider(this.identityProviderMetadataResolver, this.serviceProviderMetadataResolver, this.configuration.getSamlMessageStoreFactory());
        }
    }

    protected void initServiceProviderMetadataResolver(boolean forceReinit) {
        if (this.serviceProviderMetadataResolver == null || forceReinit) {
            this.serviceProviderMetadataResolver = new SAML2ServiceProviderMetadataResolver(this.configuration);
            this.serviceProviderMetadataResolver.resolve();
        }
    }

    protected void initIdentityProviderMetadataResolver(boolean forceReinit) {
        if (this.identityProviderMetadataResolver == null || forceReinit) {
            this.identityProviderMetadataResolver = this.configuration.getIdentityProviderMetadataResolver();
            this.identityProviderMetadataResolver.resolve(forceReinit);
        }
    }

    protected void initDecrypter(boolean forceReinit) {
        if (this.decrypter == null || forceReinit) {
            this.decrypter = new KeyStoreDecryptionProvider(this.configuration.getCredentialProvider()).build();
        }
    }

    protected void initSignatureSigningParametersProvider(boolean forceReinit) {
        if (this.signatureSigningParametersProvider == null || forceReinit) {
            this.signatureSigningParametersProvider = new DefaultSignatureSigningParametersProvider(this.configuration);
        }
    }

    protected void initSAMLReplayCache(boolean forceReinit) {
        if (this.replayCache == null || forceReinit) {
            this.replayCache = new InMemoryReplayCacheProvider();
        }
    }

    public void destroy() {
        ((SAML2ServiceProviderMetadataResolver)this.serviceProviderMetadataResolver).destroy();
    }

    public void notifySessionRenewal(CallContext ctx, String oldSessionId) {
        SessionLogoutHandler sessionLogoutHandler = this.findSessionLogoutHandler();
        if (sessionLogoutHandler != null) {
            sessionLogoutHandler.renewSession(ctx, oldSessionId);
        }
    }

    public final String getIdentityProviderResolvedEntityId() {
        return this.identityProviderMetadataResolver.getEntityId();
    }

    public final String getServiceProviderResolvedEntityId() {
        return this.serviceProviderMetadataResolver.getEntityId();
    }

    @Override
    public void close() {
        this.destroy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Client() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAMLContextProvider getContextProvider() {
        return this.contextProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SignatureSigningParametersProvider getSignatureSigningParametersProvider() {
        return this.signatureSigningParametersProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2ResponseValidator getAuthnResponseValidator() {
        return this.authnResponseValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2LogoutValidator getLogoutValidator() {
        return this.logoutValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2SignatureTrustEngineProvider getSignatureTrustEngineProvider() {
        return this.signatureTrustEngineProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        return this.identityProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2MetadataResolver getServiceProviderMetadataResolver() {
        return this.serviceProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Decrypter getDecrypter() {
        return this.decrypter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValueGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReplayCacheProvider getReplayCache() {
        return this.replayCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SOAPPipelineProvider getSoapPipelineProvider() {
        return this.soapPipelineProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2LogoutRequestMessageSender getLogoutRequestMessageSender() {
        return this.logoutRequestMessageSender;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2WebSSOMessageSender getWebSsoMessageSender() {
        return this.webSsoMessageSender;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setContextProvider(SAMLContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSignatureSigningParametersProvider(SignatureSigningParametersProvider signatureSigningParametersProvider) {
        this.signatureSigningParametersProvider = signatureSigningParametersProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAuthnResponseValidator(SAML2ResponseValidator authnResponseValidator) {
        this.authnResponseValidator = authnResponseValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLogoutValidator(SAML2LogoutValidator logoutValidator) {
        this.logoutValidator = logoutValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSignatureTrustEngineProvider(SAML2SignatureTrustEngineProvider signatureTrustEngineProvider) {
        this.signatureTrustEngineProvider = signatureTrustEngineProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setIdentityProviderMetadataResolver(SAML2MetadataResolver identityProviderMetadataResolver) {
        this.identityProviderMetadataResolver = identityProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setServiceProviderMetadataResolver(SAML2MetadataResolver serviceProviderMetadataResolver) {
        this.serviceProviderMetadataResolver = serviceProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDecrypter(Decrypter decrypter) {
        this.decrypter = decrypter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStateGenerator(ValueGenerator stateGenerator) {
        this.stateGenerator = stateGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReplayCache(ReplayCacheProvider replayCache) {
        this.replayCache = replayCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSoapPipelineProvider(SOAPPipelineProvider soapPipelineProvider) {
        this.soapPipelineProvider = soapPipelineProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLogoutRequestMessageSender(SAML2LogoutRequestMessageSender logoutRequestMessageSender) {
        this.logoutRequestMessageSender = logoutRequestMessageSender;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setWebSsoMessageSender(SAML2WebSSOMessageSender webSsoMessageSender) {
        this.webSsoMessageSender = webSsoMessageSender;
    }

    static {
        CommonHelper.assertNotNull((String)"parserPool", (Object)Configuration.getParserPool());
        CommonHelper.assertNotNull((String)"marshallerFactory", (Object)Configuration.getMarshallerFactory());
        CommonHelper.assertNotNull((String)"unmarshallerFactory", (Object)Configuration.getUnmarshallerFactory());
        CommonHelper.assertNotNull((String)"builderFactory", (Object)Configuration.getBuilderFactory());
    }
}

