/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.Configuration;

public class SAML2DelegatingMetadataResolver
implements SAML2MetadataResolver {
    private final EntityDescriptor entityDescriptorElement;
    private AbstractMetadataResolver metadataResolver;

    @Override
    public MetadataResolver resolve(boolean force) {
        if (this.metadataResolver == null) {
            try {
                this.metadataResolver = new EntityDescriptorMetadataResolver(this.entityDescriptorElement);
                this.metadataResolver.initialize();
            }
            catch (Exception e) {
                throw new SAMLException("Unable to initialize metadata resolver for " + this.entityDescriptorElement.getEntityID(), e);
            }
        }
        return this.metadataResolver;
    }

    @Override
    public String getEntityId() {
        return this.entityDescriptorElement.getEntityID();
    }

    @Override
    public String getMetadata() {
        return Configuration.serializeSamlObject((XMLObject)this.entityDescriptorElement).toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2DelegatingMetadataResolver(EntityDescriptor entityDescriptorElement) {
        this.entityDescriptorElement = entityDescriptorElement;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EntityDescriptor getEntityDescriptorElement() {
        return this.entityDescriptorElement;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractMetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    private static class EntityDescriptorMetadataResolver
    extends AbstractMetadataResolver {
        private final EntityDescriptor entityDescriptor;

        public EntityDescriptorMetadataResolver(EntityDescriptor entityDescriptor) {
            this.entityDescriptor = entityDescriptor;
            this.setId(Objects.requireNonNull(entityDescriptor.getEntityID()));
            this.setRequireValidMetadata(true);
            this.setParserPool(Configuration.getParserPool());
            this.setFailFastInitialization(true);
        }

        @Nonnull
        protected Iterable<EntityDescriptor> doResolve(CriteriaSet criteria) {
            return List.of(this.entityDescriptor);
        }
    }
}

