/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import org.apache.tools.ant.types.selectors.FilenameSelector;

public class FileHelper {
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static boolean selected(String includeFilter, String excludeFilter, String filename) {
        String[] includeFilters;
        if (includeFilter == null) {
            return false;
        }
        FilenameSelector positiveSelector = new FilenameSelector();
        FilenameSelector negativeSelector = new FilenameSelector();
        if (excludeFilter != null) {
            String[] excludeFilters;
            for (String exclude : excludeFilters = excludeFilter.split(",")) {
                negativeSelector.setName(exclude.trim());
                if (!negativeSelector.isSelected(new File("/"), filename, null)) continue;
                return false;
            }
        }
        for (String include : includeFilters = includeFilter.split(",")) {
            positiveSelector.setName(include.trim());
            if (!positiveSelector.isSelected(new File("/"), filename, null)) continue;
            return true;
        }
        return false;
    }

    public static int getSearchPathLength(String workSpace, String filterExpanded, boolean alwaysKeepParentDirectory) {
        if (alwaysKeepParentDirectory) {
            return workSpace.length() + 1;
        }
        File file1 = new File(workSpace);
        File file2 = new File(file1, filterExpanded);
        String pathWithFilter = file2.getPath();
        int indexOfWildCard = pathWithFilter.indexOf(42);
        if (indexOfWildCard > 0) {
            int folderNameEnds = pathWithFilter.substring(0, indexOfWildCard).lastIndexOf(File.separatorChar);
            return pathWithFilter.substring(0, folderNameEnds).length() + 1;
        }
        return file2.getParent().length() + 1;
    }
}

