/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3.callable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.MD5;
import hudson.plugins.s3.Uploads;
import hudson.plugins.s3.callable.MasterSlaveCallable;
import hudson.plugins.s3.callable.S3BaseUploadCallable;
import hudson.util.Secret;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;

public final class S3GzipCallable
extends S3BaseUploadCallable
implements MasterSlaveCallable<String> {
    public S3GzipCallable(String accessKey, Secret secretKey, boolean useRole, Destination dest, Map<String, String> userMetadata, String storageClass, String selregion, boolean useServerSideEncryption, ProxyConfiguration proxy, boolean usePathStyle) {
        super(accessKey, secretKey, useRole, dest, userMetadata, storageClass, selregion, useServerSideEncryption, proxy, usePathStyle);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private File gzipFile(FilePath file) throws IOException, InterruptedException {
        File localFile = File.createTempFile("s3plugin", ".bin");
        try (InputStream inputStream = file.read();
             FileOutputStream outputStream = new FileOutputStream(localFile);
             GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)outputStream, true);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)gzipStream);
            ((OutputStream)gzipStream).flush();
        }
        catch (RuntimeException ex) {
            localFile.delete();
            throw ex;
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "OBL_UNSATISFIED_OBLIGATION"})
    public String invoke(FilePath file) throws IOException, InterruptedException {
        File localFile = this.gzipFile(file);
        Upload upload = null;
        try {
            FileInputStream gzippedStream = new FileInputStream(localFile);
            Uploads.Metadata metadata = this.buildMetadata(file);
            long length = localFile.length();
            metadata.setContentLength(length);
            metadata.andThen(meta -> meta.contentEncoding("gzip").contentLength(Long.valueOf(length)));
            String md5 = MD5.generateFromFile(localFile);
            upload = Uploads.getInstance().startUploading(this.getTransferManager(), file, gzippedStream, this.getDest().bucketName, this.getDest().objectName, metadata, new CleanupHook(localFile));
            String string = md5;
            return string;
        }
        finally {
            if (upload == null || upload.completionFuture().isDone()) {
                localFile.delete();
            }
        }
    }

    private static class CleanupHook
    implements TransferListener {
        private final File localFile;

        CleanupHook(File localFile) {
            this.localFile = localFile;
        }

        public void transferComplete(TransferListener.Context.TransferComplete context) {
            this.done(context);
        }

        public void transferFailed(TransferListener.Context.TransferFailed context) {
            super.transferFailed(context);
        }

        public void done(TransferListener.Context.TransferComplete context) {
            if (this.localFile.delete()) {
                Logger.getLogger(S3GzipCallable.class.getName()).fine(() -> "Removed temporary file " + this.localFile.getName());
            } else {
                Logger.getLogger(S3GzipCallable.class.getName()).fine(() -> "Not removed temporary file " + this.localFile.getName() + " exists? " + this.localFile.exists());
            }
        }
    }
}

