/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3.callable;

import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.Uploads;
import hudson.plugins.s3.callable.S3Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import software.amazon.awssdk.core.internal.util.Mimetype;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public abstract class S3BaseUploadCallable
extends S3Callable<String> {
    private static final long serialVersionUID = 1L;
    private final Destination dest;
    private final String storageClass;
    private final Map<String, String> userMetadata;
    private final boolean useServerSideEncryption;

    public S3BaseUploadCallable(String accessKey, Secret secretKey, boolean useRole, Destination dest, Map<String, String> userMetadata, String storageClass, String selregion, boolean useServerSideEncryption, ProxyConfiguration proxy, boolean usePathStyle) {
        super(accessKey, secretKey, useRole, selregion, proxy, usePathStyle);
        this.dest = dest;
        this.storageClass = storageClass;
        this.userMetadata = userMetadata;
        this.useServerSideEncryption = useServerSideEncryption;
    }

    public String invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
        return this.invoke(new FilePath(file));
    }

    public abstract String invoke(FilePath var1) throws IOException, InterruptedException;

    protected Uploads.Metadata buildMetadata(FilePath filePath) throws IOException, InterruptedException {
        long contentLength = filePath.length();
        Consumer<PutObjectRequest.Builder> builder = metadata -> {
            metadata.contentType(Mimetype.getInstance().getMimetype(new File(filePath.getName())));
            metadata.contentLength(Long.valueOf(contentLength));
            if (this.storageClass != null && !this.storageClass.isEmpty()) {
                metadata.storageClass(this.storageClass);
            }
            if (this.useServerSideEncryption) {
                metadata.sseCustomerAlgorithm("AES256");
            }
        };
        Uploads.Metadata metadata2 = new Uploads.Metadata(builder);
        metadata2.setContentLength(contentLength);
        block14: for (Map.Entry<String, String> entry : this.userMetadata.entrySet()) {
            String key;
            switch (key = entry.getKey().toLowerCase()) {
                case "cache-control": {
                    metadata2.andThen(b1 -> b1.cacheControl((String)entry.getValue()));
                    continue block14;
                }
                case "expires": {
                    try {
                        Date expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").parse(entry.getValue());
                        metadata2.andThen(b1 -> b1.expires(expires.toInstant()));
                    }
                    catch (ParseException e) {
                        metadata2.putMetadata(entry.getKey(), entry.getValue());
                    }
                    continue block14;
                }
                case "content-encoding": {
                    metadata2.andThen(b1 -> b1.contentEncoding((String)entry.getValue()));
                    continue block14;
                }
                case "content-type": {
                    metadata2.andThen(b1 -> b1.contentType((String)entry.getValue()));
                    continue block14;
                }
            }
            metadata2.putMetadata(entry.getKey(), entry.getValue());
        }
        return metadata2;
    }

    public Destination getDest() {
        return this.dest;
    }
}

