/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import jenkins.plugins.itemstorage.s3.ClientHelper;
import jenkins.plugins.itemstorage.s3.S3Callable;

public abstract class S3BaseUploadCallable<T>
extends S3Callable<T> {
    private static final long serialVersionUID = 1L;
    private final String storageClass;
    private final Map<String, String> userMetadata;
    private final boolean useServerSideEncryption;

    public S3BaseUploadCallable(ClientHelper clientHelper, Map<String, String> userMetadata, String storageClass, boolean useServerSideEncryption) {
        super(clientHelper);
        this.storageClass = storageClass;
        this.userMetadata = userMetadata;
        this.useServerSideEncryption = useServerSideEncryption;
    }

    protected ObjectMetadata buildMetadata(File file) throws IOException {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(Mimetypes.getInstance().getMimetype(file.getName()));
        metadata.setContentLength(file.length());
        metadata.setLastModified(new Date(file.lastModified()));
        if (this.storageClass != null && !this.storageClass.isEmpty()) {
            metadata.setHeader("x-amz-storage-class", (Object)this.storageClass);
        }
        if (this.useServerSideEncryption) {
            metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        block14: for (Map.Entry<String, String> entry : this.userMetadata.entrySet()) {
            String key;
            switch (key = entry.getKey().toLowerCase()) {
                case "cache-control": {
                    metadata.setCacheControl(entry.getValue());
                    continue block14;
                }
                case "expires": {
                    try {
                        Date expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").parse(entry.getValue());
                        metadata.setHttpExpiresDate(expires);
                    }
                    catch (ParseException e) {
                        metadata.addUserMetadata(entry.getKey(), entry.getValue());
                    }
                    continue block14;
                }
                case "content-encoding": {
                    metadata.setContentEncoding(entry.getValue());
                    continue block14;
                }
                case "content-type": {
                    metadata.setContentType(entry.getValue());
                }
            }
            metadata.addUserMetadata(entry.getKey(), entry.getValue());
        }
        return metadata;
    }
}

