/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import java.io.Serializable;

public class Destination
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String bucketName;
    public final String objectName;

    public Destination(String userBucketName, String fileName) {
        if (userBucketName == null || fileName == null) {
            throw new IllegalArgumentException("Not defined for null parameters: " + userBucketName + "," + fileName);
        }
        String[] bucketNameArray = userBucketName.split("/", 2);
        String s3CompatibleFileName = this.replaceWindowsBackslashes(fileName);
        this.bucketName = bucketNameArray[0];
        this.objectName = bucketNameArray.length > 1 ? bucketNameArray[1] + "/" + s3CompatibleFileName : s3CompatibleFileName;
    }

    private String replaceWindowsBackslashes(String fileName) {
        return fileName.replace("\\", "/");
    }

    public String toString() {
        return "Destination [bucketName=" + this.bucketName + ", objectName=" + this.objectName + "]";
    }
}

