/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

public class VariableExistsCondition
extends AlwaysPrebuildRunCondition {
    private String variableName;

    @DataBoundConstructor
    public VariableExistsCondition(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String varName = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.variableName);
        listener.getLogger().println(Messages.variableExistsCondition_check(varName));
        return build.getEnvironment((TaskListener)listener).containsKey((Object)varName);
    }

    @Extension
    public static class StringsMatchDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.variableExistsCondition_displayName();
        }
    }
}

