/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

public class StringsMatchCondition
extends AlwaysPrebuildRunCondition {
    final String arg1;
    final String arg2;
    final boolean ignoreCase;

    @DataBoundConstructor
    public StringsMatchCondition(String arg1, String arg2, boolean ignoreCase) {
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.ignoreCase = ignoreCase;
    }

    public String getArg2() {
        return this.arg2;
    }

    public String getArg1() {
        return this.arg1;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String expanded1 = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.arg1);
        String expanded2 = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.arg2);
        listener.getLogger().println(Messages.stringsMatchCondition_console_args(expanded1, expanded2));
        if (expanded1 == null) {
            return false;
        }
        return this.ignoreCase ? expanded1.equalsIgnoreCase(expanded2) : expanded1.equals(expanded2);
    }

    @Extension
    public static class StringsMatchDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.stringsMatchCondition_displayName();
        }
    }
}

