/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class NumericalComparisonCondition
extends AlwaysPrebuildRunCondition {
    final String lhs;
    final String rhs;
    final Comparator comparator;

    @DataBoundConstructor
    public NumericalComparisonCondition(String lhs, String rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    public String getLhs() {
        return this.lhs;
    }

    public String getRhs() {
        return this.rhs;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String leftString = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.lhs);
        double left = Double.parseDouble(leftString);
        String rightString = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.rhs);
        double right = Double.parseDouble(rightString);
        listener.getLogger().println(Messages.numericalComparison_console_args(left, this.comparator.getDescriptor().getDisplayName(), right));
        return this.comparator.isTrue(left, right);
    }

    public static abstract class Comparator
    implements Describable<Comparator> {
        public abstract boolean isTrue(double var1, double var3);

        public Descriptor<Comparator> getDescriptor() {
            return Hudson.getInstance().getDescriptor(this.getClass());
        }

        public static abstract class ComparatorDescriptor
        extends Descriptor<Comparator> {
        }
    }

    public static class GreaterThanOrEqualTo
    extends Comparator {
        @DataBoundConstructor
        public GreaterThanOrEqualTo() {
        }

        @Override
        public boolean isTrue(double lhs, double rhs) {
            return lhs >= rhs;
        }

        @Extension(ordinal=-5.0)
        public static class GreaterThanOrEqualToDescriptor
        extends Comparator.ComparatorDescriptor {
            public String getDisplayName() {
                return Messages.numericalComparison_greaterThanOrEqualTo();
            }
        }
    }

    public static class LessThanOrEqualTo
    extends Comparator {
        @DataBoundConstructor
        public LessThanOrEqualTo() {
        }

        @Override
        public boolean isTrue(double lhs, double rhs) {
            return lhs <= rhs;
        }

        @Extension(ordinal=-4.0)
        public static class LessThanOrEqualToDescriptor
        extends Comparator.ComparatorDescriptor {
            public String getDisplayName() {
                return Messages.numericalComparison_lessThanOrEqualTo();
            }
        }
    }

    public static class NotEqualTo
    extends Comparator {
        @DataBoundConstructor
        public NotEqualTo() {
        }

        @Override
        public boolean isTrue(double lhs, double rhs) {
            return lhs != rhs;
        }

        @Extension(ordinal=-3.0)
        public static class NotEqualToDescriptor
        extends Comparator.ComparatorDescriptor {
            public String getDisplayName() {
                return Messages.numericalComparison_notEqualTo();
            }
        }
    }

    public static class EqualTo
    extends Comparator {
        @DataBoundConstructor
        public EqualTo() {
        }

        @Override
        public boolean isTrue(double lhs, double rhs) {
            return lhs == rhs;
        }

        @Extension(ordinal=-2.0)
        public static class EqualToDescriptor
        extends Comparator.ComparatorDescriptor {
            public String getDisplayName() {
                return Messages.numericalComparison_equalTo();
            }
        }
    }

    public static class GreaterThan
    extends Comparator {
        @DataBoundConstructor
        public GreaterThan() {
        }

        @Override
        public boolean isTrue(double lhs, double rhs) {
            return lhs > rhs;
        }

        @Extension(ordinal=-1.0)
        public static class GreaterThanDescriptor
        extends Comparator.ComparatorDescriptor {
            public String getDisplayName() {
                return Messages.numericalComparison_greaterThan();
            }
        }
    }

    public static class LessThan
    extends Comparator {
        @DataBoundConstructor
        public LessThan() {
        }

        @Override
        public boolean isTrue(double lhs, double rhs) {
            return lhs < rhs;
        }

        @Extension(ordinal=0.0)
        public static class LessThanDescriptor
        extends Comparator.ComparatorDescriptor {
            public String getDisplayName() {
                return Messages.numericalComparison_lessThan();
            }
        }
    }

    @Extension
    public static class NumericalComparisonConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.numericalComparison_displayName();
        }

        public List<? extends Descriptor<? extends Comparator>> getComparators() {
            return Hudson.getInstance().getDescriptorList(Comparator.class);
        }

        public FormValidation doCheckLhs(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckRhs(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

