/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExpressionCondition
extends AlwaysPrebuildRunCondition {
    final String expression;
    final String label;

    @DataBoundConstructor
    public ExpressionCondition(String expression, String label) {
        this.expression = expression;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String expandedExpression = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.expression);
        String expandedLabel = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.label);
        listener.getLogger().println(Messages.expressionCondition_console_args(expandedExpression, expandedLabel));
        return expandedLabel.matches(expandedExpression);
    }

    @Extension
    public static class ExpressionConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.expressionCondition_displayName();
        }
    }
}

