/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TreeMap;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class DayCondition
extends RunCondition {
    private final boolean useBuildTime;
    private final DaySelector daySelector;

    @DataBoundConstructor
    public DayCondition(boolean useBuildTime, DaySelector daySelector) {
        this.useBuildTime = useBuildTime;
        this.daySelector = daySelector;
    }

    public boolean isUseBuildTime() {
        return this.useBuildTime;
    }

    public DaySelector getDaySelector() {
        return this.daySelector;
    }

    @Override
    public final boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.useBuildTime ? this.isDayEnabled(this.getTimestamp(build)) : true;
    }

    @Override
    public final boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.useBuildTime ? this.isDayEnabled(this.getTimestamp(build)) : this.isDayEnabled(this.getNow());
    }

    protected Calendar getNow() {
        return Calendar.getInstance();
    }

    protected Calendar getTimestamp(AbstractBuild<?, ?> build) {
        return build.getTimestamp();
    }

    private final boolean isDayEnabled(Calendar testTime) {
        return this.daySelector.isDaySelected(testTime);
    }

    private static boolean isWeekend(Calendar calendar) {
        int day = calendar.get(7);
        return day == 7 || day == 1;
    }

    public static abstract class DaySelector
    implements Describable<DaySelector> {
        public abstract boolean isDaySelected(Calendar var1);

        public Descriptor<DaySelector> getDescriptor() {
            return Hudson.getInstance().getDescriptor(this.getClass());
        }

        public static abstract class SelectorDescriptor
        extends Descriptor<DaySelector> {
        }
    }

    public static class Day
    implements Describable<Day> {
        private final int day;
        private final boolean selected;

        @DataBoundConstructor
        public Day(int day, boolean selected) {
            this.day = day;
            this.selected = selected;
        }

        public int getDay() {
            return this.day;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public Descriptor<Day> getDescriptor() {
            return Hudson.getInstance().getDescriptorByType(DayDescriptor.class);
        }

        @Extension
        public static class DayDescriptor
        extends Descriptor<Day> {
            public String getDisplayName() {
                return "A day, innit.";
            }

            public String getDayName(int day) {
                Calendar ref = Calendar.getInstance();
                ref.set(7, day);
                return String.format(Stapler.getCurrentRequest2().getLocale(), "%tA", ref);
            }
        }
    }

    public static class SelectDays
    extends DaySelector {
        private final ArrayList<Day> days;
        private transient TreeMap<Integer, Boolean> lookup;

        @DataBoundConstructor
        public SelectDays(ArrayList<Day> days) {
            this.days = days;
            this.createLookup();
        }

        public ArrayList<Day> getDays() {
            return this.days;
        }

        @Override
        public boolean isDaySelected(Calendar testDate) {
            return this.lookup.get(testDate.get(7));
        }

        private void createLookup() {
            this.lookup = new TreeMap();
            for (Day day : this.days) {
                this.lookup.put(day.getDay(), day.isSelected());
            }
        }

        public Object readResolve() {
            this.createLookup();
            return this;
        }

        @Extension(ordinal=-2.0)
        public static class SelectDaysDescriptor
        extends DaySelector.SelectorDescriptor {
            public String getDisplayName() {
                return Messages.dayCondition_selectDays_displayName();
            }

            public ArrayList<Day> getDefaultDays() {
                return SelectDaysDescriptor.getAllDays();
            }

            public Day.DayDescriptor getDayDescriptor() {
                return (Day.DayDescriptor)Hudson.getInstance().getDescriptorByType(Day.DayDescriptor.class);
            }

            public static ArrayList<Day> getAllDays() {
                ArrayList<Day> days = new ArrayList<Day>();
                days.add(new Day(2, false));
                days.add(new Day(3, false));
                days.add(new Day(4, false));
                days.add(new Day(5, false));
                days.add(new Day(6, false));
                days.add(new Day(7, false));
                days.add(new Day(1, false));
                return days;
            }
        }
    }

    public static class Weekend
    extends DaySelector {
        @DataBoundConstructor
        public Weekend() {
        }

        @Override
        public boolean isDaySelected(Calendar testDate) {
            return DayCondition.isWeekend(testDate);
        }

        @Extension(ordinal=-1.0)
        public static class WeekendDescriptor
        extends DaySelector.SelectorDescriptor {
            public String getDisplayName() {
                return Messages.dayCondition_weekend_displayName();
            }
        }
    }

    public static class Weekday
    extends DaySelector {
        @DataBoundConstructor
        public Weekday() {
        }

        @Override
        public boolean isDaySelected(Calendar testDate) {
            return !DayCondition.isWeekend(testDate);
        }

        @Extension(ordinal=0.0)
        public static class WeekdayDescriptor
        extends DaySelector.SelectorDescriptor {
            public String getDisplayName() {
                return Messages.dayCondition_weekday_displayName();
            }
        }
    }

    @Extension
    public static class DayConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.dayCondition_displayName();
        }

        public List<? extends Descriptor<? extends DaySelector>> getDaySelectors() {
            return Hudson.getInstance().getDescriptorList(DaySelector.class);
        }
    }
}

