/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.contributed;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.contributed.Messages;

public abstract class CommandInterperterCondition
extends AlwaysPrebuildRunCondition {
    protected final String command;

    public CommandInterperterCondition(String command) {
        this.command = command;
    }

    public final String getCommand() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException {
        boolean bl;
        FilePath ws = build.getWorkspace();
        if (ws == null) {
            return false;
        }
        FilePath script = null;
        Launcher launcher = null;
        try {
            launcher = ws.createLauncher((TaskListener)listener);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_UnableToCreateLauncher(ws)));
            boolean bl2 = false;
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e2) {
                Util.displayIOException((IOException)e2, (TaskListener)listener);
                e2.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_UnableToDelete(script)));
            }
            return bl2;
        }
        try {
            script = this.createScriptFile(ws);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_UnableToProduceScript()));
            boolean bl3 = false;
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e3) {
                Util.displayIOException((IOException)e3, (TaskListener)listener);
                e3.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_UnableToDelete(script)));
            }
            return bl3;
        }
        try {
            int r;
            try {
                EnvVars envVars = build.getEnvironment((TaskListener)listener);
                for (Map.Entry e : build.getBuildVariables().entrySet()) {
                    envVars.put((String)e.getKey(), (String)e.getValue());
                }
                r = launcher.launch().cmds(this.buildCommandLine(script)).envs((Map)envVars).stdout((TaskListener)listener).pwd(ws).join();
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_CommandFailed()));
                r = -1;
            }
            bl = r == 0;
        }
        catch (Throwable throwable) {
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_UnableToDelete(script)));
            }
            throw throwable;
        }
        try {
            if (script != null) {
                script.delete();
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.CommandInterpreterCondition_UnableToDelete(script)));
        }
        return bl;
    }

    public FilePath createScriptFile(FilePath dir) throws IOException, InterruptedException {
        return dir.createTextTempFile("CommandInterpreterCondition", this.getFileExtension(), this.getContents(), false);
    }

    public abstract String[] buildCommandLine(FilePath var1);

    protected abstract String getContents();

    protected abstract String getFileExtension();
}

