/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStep;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class BuildStepRunner
implements Describable<BuildStepRunner> {
    private static final Logger LOGGER = Logger.getLogger(BuildStepRunner.class.getName());

    public static DescriptorExtensionList<BuildStepRunner, BuildStepRunnerDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(BuildStepRunner.class);
    }

    private static void logEvaluateException(BuildListener listener, Exception e, String displayName) {
        String msg = Messages.runner_console_exception(e.getClass().getName() + ": " + e.getLocalizedMessage(), displayName);
        LOGGER.log(Level.WARNING, msg, e);
        listener.getLogger().println(msg);
    }

    private static void setResult(AbstractBuild<?, ?> build, Result result) {
        Result auxResult = build.getResult();
        if (auxResult == null) {
            build.setResult(result);
        } else {
            build.setResult(result.combine(auxResult));
        }
    }

    private static String getDisplayName(Describable describable) {
        return describable.getDescriptor().getDisplayName();
    }

    public abstract boolean conditionalRun(ConditionAndStep var1, AbstractBuild<?, ?> var2, BuildListener var3) throws IOException, InterruptedException;

    public final boolean prebuild(final RunCondition condition, final BuildStep buildStep, final AbstractBuild<?, ?> build, final BuildListener listener) {
        try {
            return this.conditionalRun(new ConditionAndStep(){

                @Override
                public boolean evaluate() throws Exception {
                    return condition.runPrebuild(build, listener);
                }

                @Override
                public boolean run() {
                    return buildStep.prebuild(build, listener);
                }

                @Override
                public void logRunning(boolean running) {
                    if (running) {
                        listener.getLogger().println(Messages.runner_condition_true(BuildStepRunner.getDisplayName(condition), Messages.runner_stage_prebuild(), BuildStepRunner.getDisplayName((Describable)buildStep)));
                    } else {
                        listener.getLogger().println(Messages.runner_condition_false(BuildStepRunner.getDisplayName(condition), Messages.runner_stage_prebuild(), BuildStepRunner.getDisplayName((Describable)buildStep)));
                    }
                }
            }, build, listener);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public final boolean perform(final RunCondition condition, final BuildStep buildStep, final AbstractBuild<?, ?> build, final Launcher launcher, final BuildListener listener) throws InterruptedException, IOException {
        return this.conditionalRun(new ConditionAndStep(){

            @Override
            public boolean evaluate() throws Exception {
                return condition.runPerform(build, listener);
            }

            @Override
            public boolean run() throws IOException, InterruptedException {
                return buildStep.perform(build, launcher, listener);
            }

            @Override
            public void logRunning(boolean running) {
                if (running) {
                    listener.getLogger().println(Messages.runner_condition_true(BuildStepRunner.getDisplayName(condition), Messages.runner_stage_perform(), BuildStepRunner.getDisplayName((Describable)buildStep)));
                } else {
                    listener.getLogger().println(Messages.runner_condition_false(BuildStepRunner.getDisplayName(condition), Messages.runner_stage_perform(), BuildStepRunner.getDisplayName((Describable)buildStep)));
                }
            }
        }, build, listener);
    }

    public BuildStepRunnerDescriptor getDescriptor() {
        return (BuildStepRunnerDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    private static interface ConditionAndStep {
        public boolean evaluate() throws Exception;

        public boolean run() throws IOException, InterruptedException;

        public void logRunning(boolean var1);
    }

    public static abstract class BuildStepRunnerDescriptor
    extends Descriptor<BuildStepRunner> {
        protected BuildStepRunnerDescriptor() {
        }
    }

    public static class DontRun
    extends BuildStepRunner {
        @DataBoundConstructor
        public DontRun() {
        }

        @Override
        public boolean conditionalRun(ConditionAndStep target, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
            boolean run = false;
            try {
                run = target.evaluate();
                target.logRunning(run);
            }
            catch (Exception e) {
                BuildStepRunner.logEvaluateException(listener, e, Messages.runner_dontRun_displayName());
            }
            return run ? target.run() : true;
        }

        @Extension(ordinal=-4.0)
        public static class DontRunDescriptor
        extends BuildStepRunnerDescriptor {
            public String getDisplayName() {
                return Messages.runner_dontRun_displayName();
            }
        }
    }

    public static class Run
    extends BuildStepRunner {
        @DataBoundConstructor
        public Run() {
        }

        @Override
        public boolean conditionalRun(ConditionAndStep target, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
            boolean run = true;
            try {
                run = target.evaluate();
                target.logRunning(run);
            }
            catch (Exception e) {
                BuildStepRunner.logEvaluateException(listener, e, Messages.runner_run_displayName());
            }
            return run ? target.run() : true;
        }

        @Extension(ordinal=-3.0)
        public static class RunDescriptor
        extends BuildStepRunnerDescriptor {
            public String getDisplayName() {
                return Messages.runner_run_displayName();
            }
        }
    }

    public static class RunUnstable
    extends BuildStepRunner {
        @DataBoundConstructor
        public RunUnstable() {
        }

        @Override
        public boolean conditionalRun(ConditionAndStep target, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
            boolean run = true;
            try {
                run = target.evaluate();
                target.logRunning(run);
            }
            catch (Exception e) {
                BuildStepRunner.logEvaluateException(listener, e, Messages.runner_runUnstable_displayName());
                BuildStepRunner.setResult(build, Result.UNSTABLE);
            }
            return run ? target.run() : true;
        }

        @Extension(ordinal=-2.0)
        public static class RunUnstableDescriptor
        extends BuildStepRunnerDescriptor {
            public String getDisplayName() {
                return Messages.runner_runUnstable_displayName();
            }
        }
    }

    public static class Unstable
    extends BuildStepRunner {
        @DataBoundConstructor
        public Unstable() {
        }

        @Override
        public boolean conditionalRun(ConditionAndStep target, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
            boolean run = false;
            try {
                run = target.evaluate();
                target.logRunning(run);
            }
            catch (Exception e) {
                BuildStepRunner.logEvaluateException(listener, e, Messages.runner_unstable_displayName());
                BuildStepRunner.setResult(build, Result.UNSTABLE);
            }
            return run ? target.run() : true;
        }

        @Extension(ordinal=-1.0)
        public static class UnstableDescriptor
        extends BuildStepRunnerDescriptor {
            public String getDisplayName() {
                return Messages.runner_unstable_displayName();
            }
        }
    }

    public static class Fail
    extends BuildStepRunner {
        @DataBoundConstructor
        public Fail() {
        }

        @Override
        public boolean conditionalRun(ConditionAndStep target, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
            boolean run = false;
            try {
                run = target.evaluate();
                target.logRunning(run);
            }
            catch (Exception e) {
                BuildStepRunner.logEvaluateException(listener, e, Messages.runner_fail_displayName());
                BuildStepRunner.setResult(build, Result.FAILURE);
                return false;
            }
            return run ? target.run() : true;
        }

        @Extension(ordinal=0.0)
        public static class FailDescriptor
        extends BuildStepRunnerDescriptor {
            public String getDisplayName() {
                return Messages.runner_fail_displayName();
            }
        }
    }
}

