/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.pipeline;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.springframework.security.core.Authentication;

public abstract class AbstractUserRolesStep
extends Step {

    protected static class Execution
    extends SynchronousNonBlockingStepExecution<Set<String>> {
        protected final RoleType roleType;

        public Execution(@NonNull StepContext context, RoleType roleType) {
            super(context);
            this.roleType = roleType;
        }

        protected RoleMap getRoleMap() throws IOException, InterruptedException {
            AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
            if (strategy instanceof RoleBasedAuthorizationStrategy) {
                RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)strategy;
                return rbas.getRoleMap(this.roleType);
            }
            return null;
        }

        protected Set<String> run() throws Exception {
            HashSet<String> roleSet = new HashSet<String>();
            Authentication auth = this.getAuthentication();
            if (auth == null) {
                return roleSet;
            }
            RoleMap roleMap = this.getRoleMap();
            if (roleMap != null) {
                if (auth == ACL.SYSTEM2) {
                    return roleMap.getRoles().stream().map(Role::getName).collect(Collectors.toSet());
                }
                return roleMap.getRolesForAuth(auth);
            }
            return roleSet;
        }

        private Authentication getAuthentication() throws IOException, InterruptedException {
            User causeUser;
            Run run = Objects.requireNonNull((Run)this.getContext().get(Run.class));
            Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
            if (cause != null && (causeUser = User.getById((String)cause.getUserId(), (boolean)false)) != null) {
                return causeUser.impersonate2();
            }
            Authentication auth = Jenkins.getAuthentication2();
            if (ACL.isAnonymous2((Authentication)auth)) {
                return null;
            }
            return auth;
        }
    }
}

