/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.permissions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.PluginManager;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PermissionHelper {
    private static final Logger LOGGER = Logger.getLogger(PermissionHelper.class.getName());
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("^([^\\/]+)\\/(.+)$");
    @Restricted(value={NoExternalUse.class})
    public static final Set<Permission> DANGEROUS_PERMISSIONS = Collections.unmodifiableSet(new HashSet<Permission>(Arrays.asList(Jenkins.RUN_SCRIPTS, PluginManager.CONFIGURE_UPDATECENTER, PluginManager.UPLOAD_PLUGINS)));

    private PermissionHelper() {
    }

    @NonNull
    public static Set<Permission> fromStrings(@CheckForNull Collection<String> permissionStrings, boolean allowPermissionId) {
        if (permissionStrings == null) {
            return Collections.emptySet();
        }
        HashSet<Permission> res = new HashSet<Permission>(permissionStrings.size());
        for (String permission : permissionStrings) {
            Permission p;
            Permission permission2 = p = allowPermissionId ? PermissionHelper.resolvePermissionFromString(permission) : PermissionHelper.findPermission(permission);
            if (p == null) {
                LOGGER.log(Level.WARNING, "Ignoring unresolved permission: " + permission);
                continue;
            }
            res.add(p);
        }
        return res;
    }

    public static boolean isDangerous(Permission p) {
        return DANGEROUS_PERMISSIONS.contains(p);
    }

    @CheckForNull
    public static Permission findPermission(String id) {
        String resolvedId = PermissionHelper.findPermissionId(id);
        return resolvedId != null ? PermissionHelper.getSafePermission(resolvedId) : null;
    }

    @CheckForNull
    public static String findPermissionId(String id) {
        if (id == null) {
            return null;
        }
        List pgs = PermissionGroup.getAll();
        Matcher m = PERMISSION_PATTERN.matcher(id);
        if (m.matches()) {
            String owner = m.group(1);
            String name = m.group(2);
            for (PermissionGroup pg : pgs) {
                if (pg.owner.equals(Permission.class) || !pg.getId().equals(owner)) continue;
                return pg.owner.getName() + "." + name;
            }
        }
        return null;
    }

    @CheckForNull
    private static Permission getSafePermission(String id) {
        Permission permission = Permission.fromId((String)id);
        if (permission != null && PermissionHelper.isDangerous(permission)) {
            LOGGER.log(Level.WARNING, "The permission: '" + String.valueOf(permission) + "' is dangerous and will be ignored.");
            return null;
        }
        return permission;
    }

    @CheckForNull
    public static Permission resolvePermissionFromString(String id) {
        Permission permission = PermissionHelper.getSafePermission(id);
        if (permission == null) {
            permission = PermissionHelper.findPermission(id);
        }
        return permission;
    }
}

