/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AdministrativeMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class AmbiguousSidsAdminMonitor
extends AdministrativeMonitor {
    @NonNull
    private List<String> ambiguousEntries = Collections.emptyList();

    @NonNull
    public static AmbiguousSidsAdminMonitor get() {
        return (AmbiguousSidsAdminMonitor)((Object)ExtensionList.lookupSingleton(AmbiguousSidsAdminMonitor.class));
    }

    public void updateEntries(@NonNull Collection<PermissionEntry> entries) {
        ArrayList<String> ambiguous = new ArrayList<String>();
        for (PermissionEntry entry : entries) {
            try {
                if (entry.getType() != AuthorizationType.EITHER) continue;
                ambiguous.add(entry.getSid());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.ambiguousEntries = ambiguous;
    }

    @NonNull
    public List<String> getAmbiguousEntries() {
        return this.ambiguousEntries;
    }

    public boolean isActivated() {
        return !this.ambiguousEntries.isEmpty();
    }

    public String getDisplayName() {
        return Messages.RoleBasedProjectNamingStrategy_Ambiguous();
    }
}

