/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier.rocket;

import jenkins.plugins.rocketchatnotifier.rocket.RocketChatCallAuthentication;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatRestApiV1;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import kong.unirest.json.JSONObject;

public class RocketChatBasicCallAuthentication
implements RocketChatCallAuthentication {
    private final String serverUrl;
    private final String user;
    private final String password;
    private String authToken = "";
    private String userId = "";

    public RocketChatBasicCallAuthentication(String serverUrl, String user, String password) {
        if (!((String)serverUrl).endsWith("/")) {
            serverUrl = (String)serverUrl + "/";
        }
        if (!((String)serverUrl).startsWith("http")) {
            serverUrl = "https://" + (String)serverUrl;
        }
        this.serverUrl = !((String)serverUrl).endsWith("api/") ? (String)serverUrl + "api/" : serverUrl;
        this.user = user;
        this.password = password;
    }

    @Override
    public boolean isAuthenticated() {
        return !this.authToken.isEmpty() && !this.userId.isEmpty();
    }

    @Override
    public void doAuthentication() throws RocketClientException {
        HttpResponse loginResult;
        String apiURL = this.serverUrl + "v1/login";
        String userInfoUrl = this.serverUrl + "v1/me";
        try {
            loginResult = Unirest.post((String)apiURL).field("user", (Object)this.user).field("password", this.password).asJson();
        }
        catch (UnirestException e) {
            throw new RocketClientException("Please check if the server API " + apiURL + " is correct: (Login-Error 1)", e);
        }
        if (loginResult.getStatus() == 401) {
            try {
                loginResult = ((GetRequest)((GetRequest)Unirest.get((String)userInfoUrl).header("X-User-Id", this.user)).header("X-Auth-Token", this.password)).asJson();
                if (loginResult.getStatus() == 401) {
                    throw new RocketClientException("The username and password provided are incorrect.");
                }
                this.userId = this.user;
                this.authToken = this.password;
            }
            catch (UnirestException e) {
                throw new RocketClientException("Please check if the server API " + apiURL + " is correct (Login-Error 2)", e);
            }
        } else {
            JSONObject data = ((JsonNode)loginResult.getBody()).getObject().getJSONObject("data");
            this.userId = data.getString("userId");
            this.authToken = data.getString("authToken");
        }
        if (loginResult.getStatus() != 200) {
            throw new RocketClientException("The login failed with a result of (Login-Error 3): " + loginResult.getStatus());
        }
    }

    @Override
    public String getUrlForRequest(RocketChatRestApiV1 call) {
        if (call.getMethodName().contains("/info")) {
            return this.serverUrl + "info";
        }
        return this.serverUrl + call.getMethodName();
    }

    @Override
    public void addAuthenticationDataToRequest(HttpRequest request) {
        request.header("X-Auth-Token", this.authToken);
        request.header("X-User-Id", this.userId);
    }
}

