/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.robot.RobotStepExecution;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RobotStep
extends Step {
    private static final Logger logger = Logger.getLogger(RobotStep.class.getName());
    @CheckForNull
    private String archiveDirName;
    @NonNull
    private final String outputPath;
    @CheckForNull
    private String reportFileName;
    @CheckForNull
    private String logFileName;
    @CheckForNull
    private String outputFileName;
    private boolean disableArchiveOutput;
    private double passThreshold;
    private double unstableThreshold;
    @CheckForNull
    private String[] otherFiles;
    private boolean enableCache = true;
    private boolean countSkippedTests = false;
    @CheckForNull
    private String overwriteXAxisLabel;
    private boolean useArtifactManager = false;

    @DataBoundConstructor
    public RobotStep(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getArchiveDirName() {
        return this.archiveDirName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean getDisableArchiveOutput() {
        return this.disableArchiveOutput;
    }

    public double getPassThreshold() {
        return this.passThreshold;
    }

    public double getUnstableThreshold() {
        return this.unstableThreshold;
    }

    public String getOtherFiles() {
        return StringUtils.join((Object[])this.otherFiles, (String)",");
    }

    public boolean getEnableCache() {
        return this.enableCache;
    }

    public boolean getCountSkippedTests() {
        return this.countSkippedTests;
    }

    public String getOverwriteXAxisLabel() {
        return this.overwriteXAxisLabel;
    }

    public boolean getUseArtifactManager() {
        return this.useArtifactManager;
    }

    @DataBoundSetter
    public void setArchiveDirName(String archiveDirName) {
        this.archiveDirName = Util.fixEmpty((String)archiveDirName);
    }

    @DataBoundSetter
    public void setReportFileName(String reportFileName) {
        this.reportFileName = Util.fixEmpty((String)reportFileName);
    }

    @DataBoundSetter
    public void setLogFileName(String logFileName) {
        this.logFileName = Util.fixEmpty((String)logFileName);
    }

    @DataBoundSetter
    public void setOutputFileName(String outputFileName) {
        this.outputFileName = Util.fixEmpty((String)outputFileName);
    }

    @DataBoundSetter
    public void setDisableArchiveOutput(boolean disableArchiveOutput) {
        this.disableArchiveOutput = disableArchiveOutput;
    }

    @DataBoundSetter
    public void setPassThreshold(double passThreshold) {
        this.passThreshold = passThreshold;
    }

    @DataBoundSetter
    public void setUnstableThreshold(double unstableThreshold) {
        this.unstableThreshold = unstableThreshold;
    }

    @DataBoundSetter
    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    @DataBoundSetter
    public void setCountSkippedTests(boolean countSkippedTests) {
        this.countSkippedTests = countSkippedTests;
    }

    @DataBoundSetter
    public void setOtherFiles(String otherFiles) {
        if ((otherFiles = Util.fixEmpty((String)otherFiles)) != null) {
            String[] filemasks = otherFiles.split("[, ]+");
            for (int i = 0; i < filemasks.length; ++i) {
                filemasks[i] = StringUtils.strip((String)filemasks[i]);
            }
            this.otherFiles = filemasks;
        }
    }

    @DataBoundSetter
    public void setOverwriteXAxisLabel(String overwriteXAxisLabel) {
        this.overwriteXAxisLabel = overwriteXAxisLabel;
    }

    @DataBoundSetter
    public void setUseArtifactManager(boolean useArtifactManager) {
        this.useArtifactManager = useArtifactManager;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new RobotStepExecution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "robot";
        }

        public String getDisplayName() {
            return "Configure robot framework report collection";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }
    }
}

