/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger.auth2;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.util.Secret;
import io.jenkins.plugins.remote.result.trigger.auth2.Auth2;
import io.jenkins.plugins.remote.result.trigger.exceptions.CredentialsNotFoundException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TokenAuth
extends Auth2 {
    private static final long serialVersionUID = 7912089565969112023L;
    @Extension
    public static final Auth2.Auth2Descriptor DESCRIPTOR = new TokenAuthDescriptor();
    private String userName = null;
    private Secret apiToken = null;

    @DataBoundConstructor
    public TokenAuth() {
    }

    @DataBoundSetter
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @DataBoundSetter
    public void setApiToken(Secret apiToken) {
        this.apiToken = apiToken;
    }

    @Override
    public String getCredentials(Item item) throws CredentialsNotFoundException {
        if (StringUtils.isNotEmpty((String)this.userName) && this.apiToken != null) {
            String username = this.getUserName();
            String token = this.getApiToken().getPlainText();
            return "Basic " + Base64.encodeBase64String((byte[])(username + ":" + token).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    @Override
    public String toString() {
        return "'" + this.getDescriptor().getDisplayName() + "' as user '" + this.getUserName() + "'";
    }

    @Override
    public String toString(Item item) {
        return this.toString();
    }

    public Auth2.Auth2Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apiToken == null ? 0 : this.apiToken.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        TokenAuth other = (TokenAuth)obj;
        if (this.apiToken == null ? other.apiToken != null : !this.apiToken.equals((Object)other.apiToken)) {
            return false;
        }
        if (this.userName == null) {
            return other.userName == null;
        }
        return this.userName.equals(other.userName);
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Secret getApiToken() {
        return this.apiToken;
    }

    @Symbol(value={"TokenAuth"})
    public static class TokenAuthDescriptor
    extends Auth2.Auth2Descriptor {
        @NonNull
        public String getDisplayName() {
            return "Token Authentication";
        }
    }
}

