/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.remote.result.trigger.auth2.Auth2;
import io.jenkins.plugins.remote.result.trigger.auth2.NoneAuth;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class RemoteJenkinsServer
implements Describable<RemoteJenkinsServer>,
Serializable {
    private static final long serialVersionUID = -9211781849078964416L;
    private String id;
    private String displayName;
    private boolean trustAllCertificates;
    private Auth2 auth2;
    private String url;

    public Descriptor<RemoteJenkinsServer> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @DataBoundConstructor
    public RemoteJenkinsServer() {
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = id;
    }

    @DataBoundSetter
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @DataBoundSetter
    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    @DataBoundSetter
    public void setAuth2(Auth2 auth2) {
        this.auth2 = auth2;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    @Generated
    public Auth2 getAuth2() {
        return this.auth2;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RemoteJenkinsServer> {
        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (StringUtils.isEmpty((String)url)) {
                return FormValidation.error((String)"The remote address can not be empty.");
            }
            try {
                URL host = new URL(url);
                host.toURI();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Malformed address (" + url + "). Remember to indicate the protocol, i.e. http, https, etc."));
            }
            return FormValidation.ok();
        }

        public static List<Auth2.Auth2Descriptor> getAuth2Descriptors() {
            return Auth2.all();
        }

        public static Auth2.Auth2Descriptor getDefaultAuth2Descriptor() {
            return NoneAuth.DESCRIPTOR;
        }
    }
}

