/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.BuildableItem;
import io.jenkins.plugins.remote.result.trigger.model.JobResultDisplayInfo;
import io.jenkins.plugins.remote.result.trigger.model.JobResultInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RemoteBuildResultTriggerScheduledAction
implements Action {
    private final transient BuildableItem item;
    private final List<JobResultInfo> jobResultInfos;

    public RemoteBuildResultTriggerScheduledAction(BuildableItem item, List<JobResultInfo> jobResultInfos) {
        this.item = item;
        this.jobResultInfos = jobResultInfos;
    }

    @NonNull
    public List<JobResultInfo> getJobResultInfos() {
        return this.jobResultInfos;
    }

    public List<JobResultDisplayInfo> getJobResultDisplayInfos() throws IOException {
        ObjectWriter jsonPretty = new ObjectMapper().writerWithDefaultPrettyPrinter();
        ArrayList<JobResultDisplayInfo> results = new ArrayList<JobResultDisplayInfo>();
        for (JobResultInfo jobResultInfo : this.jobResultInfos) {
            JobResultDisplayInfo info = new JobResultDisplayInfo();
            info.setRemoteJobUrl(jobResultInfo.getRemoteJobUrl());
            info.setBuildUrl(jobResultInfo.getBuildUrl());
            info.setResult(jsonPretty.writeValueAsString(jobResultInfo.getBuildResult()));
            if (jobResultInfo.getRemoteResult() != null) {
                info.setResultJson(jsonPretty.writeValueAsString(jobResultInfo.getRemoteResult()));
            }
            results.add(info);
        }
        return results;
    }

    public String getIconFileName() {
        return "symbol-details";
    }

    public String getDisplayName() {
        return "Remote Result Trigger";
    }

    public String getUrlName() {
        return "remote-result-trigger";
    }

    @Generated
    public BuildableItem getItem() {
        return this.item;
    }
}

