/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.containerSecurity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.containerSecurity.QualysEvaluationException;
import com.qualys.plugins.containerSecurity.QualysTaggingFailException;
import com.qualys.plugins.containerSecurity.common.QualysAuth.QualysAuth;
import com.qualys.plugins.containerSecurity.common.QualysClient.QualysCSClient;
import com.qualys.plugins.containerSecurity.common.QualysClient.QualysCSResponse;
import com.qualys.plugins.containerSecurity.util.Helper;
import hudson.AbortException;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class GetImageVulnsCallable
implements Callable<String> {
    private String imageId;
    private String imageSha;
    private PrintStream buildLogger;
    private int pollingIntervalForVulns;
    private int vulnsTimeout;
    public Set<String> reposArray;
    private String buildDirPath;
    private boolean isFailConditionsConfigured;
    private QualysCSClient qualysClient;
    private long taggingTime;
    private static final Logger logger = Logger.getLogger(GetImageVulnsCallable.class.getName());

    public GetImageVulnsCallable(long taggingTime, String imageSha, QualysCSClient qualysClient, TaskListener listener, int pollingIntervalForVulns, int vulnsTimeout, String buildDirPath, boolean isFailConditionsConfigured, QualysAuth auth) throws AbortException {
        this.taggingTime = taggingTime;
        this.imageSha = imageSha;
        this.imageId = imageSha.substring(0, 12);
        this.buildLogger = listener.getLogger();
        this.pollingIntervalForVulns = pollingIntervalForVulns;
        this.vulnsTimeout = vulnsTimeout;
        this.buildDirPath = buildDirPath;
        this.isFailConditionsConfigured = isFailConditionsConfigured;
        this.qualysClient = qualysClient;
    }

    @Override
    public String call() throws QualysEvaluationException, Exception {
        this.buildLogger.println("Thread for Image Id  = " + this.imageId + ", " + Thread.currentThread().getName() + " Started");
        try {
            return this.fetchScanResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String fetchScanResult() throws QualysEvaluationException, Exception {
        String scanResult = null;
        long startTime = System.currentTimeMillis();
        long vulnsTimeoutInMillis = TimeUnit.SECONDS.toMillis(this.vulnsTimeout);
        long pollingInMillis = TimeUnit.SECONDS.toMillis(this.pollingIntervalForVulns);
        Instant instant = Instant.now();
        long currentTime = instant.getEpochSecond();
        this.buildLogger.println("***Current Epoch Time in seconds = " + currentTime);
        long nowMinusSeconds = currentTime - this.taggingTime;
        block4: while (true) {
            while ((scanResult = this.getScanReport(this.imageSha, nowMinusSeconds)) == null) {
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > vulnsTimeoutInMillis) {
                    this.buildLogger.println("Failed to get scan result; timeout of " + this.vulnsTimeout + " seconds reached. Please check if image " + this.imageId + " is synced with API server.");
                    if (!this.isFailConditionsConfigured) break block4;
                    throw new QualysEvaluationException("Timeout reached fetching scan result for image " + this.imageId);
                }
                try {
                    this.buildLogger.println("Waiting for " + this.pollingIntervalForVulns + " seconds before making next attempt for " + this.imageId + " ...");
                    Thread.sleep(pollingInMillis);
                    nowMinusSeconds += (long)this.pollingIntervalForVulns;
                    continue block4;
                }
                catch (InterruptedException e) {
                    this.buildLogger.println("Error waiting for scan result..");
                }
            }
            break;
        }
        if (scanResult == null || scanResult.isEmpty()) {
            if (this.isFailConditionsConfigured) {
                throw new Exception("No vulnerabilities data for image " + this.imageId + " found.");
            }
            this.buildLogger.println("No vulnerabilities data for image " + this.imageId + " found.");
            return null;
        }
        Helper.createNewFile(this.buildDirPath, "qualys_" + this.imageId, scanResult, this.buildLogger);
        return scanResult;
    }

    private String getScanReport(String imageSha, long nowMinusSeconds) throws Exception {
        try {
            QualysCSResponse resp = null;
            resp = this.qualysClient.getImages(imageSha, nowMinusSeconds);
            logger.info("Received response code: " + resp.responseCode);
            if (resp.responseCode == 400) {
                this.buildLogger.println("Bad request. response code: " + resp.responseCode + " Message: " + resp.response.get("message").toString());
                return null;
            }
            if (resp.responseCode >= 500 && resp.responseCode <= 599) {
                this.buildLogger.println("HTTP Code: " + resp.responseCode + ". Image: N/A. Vulnerabilities: N/A.");
                this.buildLogger.println("Waiting for image data from Qualys for image id " + this.imageId);
                return null;
            }
            if (resp.errored) {
                logger.info("Qualys API server URL is not correct or it is not reachable. Error message: " + resp.errorMessage);
                throw new Exception("Qualys API server URL is not correct or it is not reachable. Error message: " + resp.errorMessage);
            }
            if (resp.responseCode == 204) {
                this.buildLogger.println("Waiting for image data from Qualys for image id " + this.imageId);
                this.buildLogger.println("HTTP Code: " + resp.responseCode + ". Image details for " + this.imageId + " last scanned within last " + nowMinusSeconds + " seconds not found yet.");
                return null;
            }
            if (resp.responseCode == 200 && resp.response != null) {
                this.buildLogger.println("HTTP Code: " + resp.responseCode + ". Data available; Now fetching image details for imageId " + this.imageId);
                resp = this.qualysClient.getImageDetails(imageSha);
                JsonObject jsonObj = resp.response;
                String scanResult = jsonObj.toString();
                JsonElement vulns = jsonObj.get("vulnerabilities");
                if (vulns == null || vulns.isJsonNull()) {
                    this.buildLogger.println("Waiting for vulnerabilities data from Qualys for image id " + this.imageId);
                    this.buildLogger.println("HTTP Code: 200. Image: known to Qualys. Vulnerabilities: To be processed.");
                    return null;
                }
                return scanResult;
            }
            this.buildLogger.println("HTTP Code: " + resp.responseCode + ". Image: Not known to Qualys. Vulnerabilities: To be processed.. API Response : " + String.valueOf(resp.response));
            return null;
        }
        catch (QualysTaggingFailException e) {
            this.buildLogger.println("Error: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.info("Error fetching scan report for image " + this.imageId + ", reason : " + e.getMessage());
            this.buildLogger.println("Error fetching scan report for image " + this.imageId + ", reason : " + e.getMessage());
            return null;
        }
    }

    public String toString() {
        return this.imageId;
    }
}

