/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.common.QualysClient;

import com.qualys.plugins.common.QualysAuth.QualysAuth;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;

class QualysBaseClient {
    private QualysAuth auth;
    protected PrintStream stream;
    protected int timeout = 30;

    public QualysBaseClient(QualysAuth auth, PrintStream stream) {
        this.auth = auth;
        this.stream = stream;
    }

    public URL getAbsoluteUrl(String path) throws MalformedURLException {
        path = path.startsWith("/") ? path : "/" + path;
        URL url = new URL(this.auth.getServer() + path);
        return url;
    }

    protected Map<String, String> getAuthHeaders() throws UnsupportedEncodingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", "application/json");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("BASIC")) {
            return headers;
        }
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("OAUTH")) {
            headers.put("clientId", this.auth.getClientId());
            headers.put("clientSecret", this.auth.getClientSecret());
            return headers;
        }
        return null;
    }

    protected String getAuthEndpoint(Map<String, String> apiMap) {
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("BASIC")) {
            return apiMap.get("getAuth");
        }
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("OAUTH")) {
            return apiMap.get("getUserLevelOAuth");
        }
        return null;
    }

    protected byte[] getAuthEntity() throws UnsupportedEncodingException {
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("BASIC")) {
            return this.getBasicAuthJWTEncodedEntity();
        }
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("OAUTH")) {
            return new byte[0];
        }
        return null;
    }

    protected byte[] getBasicAuthJWTEncodedEntity() throws UnsupportedEncodingException {
        String userPass = "username=" + URLEncoder.encode(this.auth.getUsername(), "UTF-8") + "&password=" + URLEncoder.encode(this.auth.getPassword(), "UTF-8") + "&token=true";
        return userPass.getBytes();
    }

    protected CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeout * 1000).setConnectionRequestTimeout(this.timeout * 1000).setSocketTimeout(this.timeout * 1000).build();
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultRequestConfig(config);
        clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.auth.getProxyServer() != null && !this.auth.getProxyServer().isEmpty()) {
            HttpHost proxyHost = new HttpHost(this.auth.getProxyServer(), this.auth.getProxyPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            clientBuilder.setRoutePlanner(routePlanner);
            String username = this.auth.getProxyUsername();
            String password = this.auth.getProxyPassword();
            if (username != null && !"".equals(username.trim())) {
                System.out.println("Using proxy authentication (user=" + username + ")");
                credentialsProvider.setCredentials(new AuthScope(proxyHost), new UsernamePasswordCredentials(username, password));
            }
        }
        return clientBuilder.build();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

