/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.common.QualysAuth;

import com.qualys.plugins.common.QualysAuth.AuthType;
import java.util.ArrayList;
import java.util.List;

public class QualysAuth {
    private AuthType authType;
    private String server;
    private String username;
    private String password;
    private String clientId;
    private String clientSecret;
    private String authKey;
    private String proxyServer;
    private String proxyUsername;
    private String proxyPassword;
    private int proxyPort;
    private String gatewayURL = null;
    public static List<String> serverPlatformURL = new ArrayList<String>();
    public static List<String> serverApiURL = new ArrayList<String>();
    public static List<String> serverGatewayURL = new ArrayList<String>();

    public QualysAuth() {
    }

    public QualysAuth(String server, String oauthKey) {
        this.authType = AuthType.OAuth;
        this.authKey = oauthKey;
    }

    public String getServer() {
        if (this.gatewayURL == null) {
            int pos;
            if (this.server.endsWith("/")) {
                this.server = this.server.substring(0, this.server.length() - 1);
            }
            if ((pos = serverPlatformURL.indexOf(this.server)) == -1) {
                pos = serverApiURL.indexOf(this.server);
            }
            if (pos == -1) {
                pos = serverGatewayURL.indexOf(this.server);
            }
            this.gatewayURL = pos == -1 ? this.server.replace("https://qualysapi.", "https://qualysgateway.") : serverGatewayURL.get(pos);
        }
        return this.gatewayURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getPortalURL() {
        return this.server.replace("qualysapi", "qualysguard");
    }

    public void setQualysCredentials(String server, AuthType authType, String username, String password, String clientId, String clientSecret) {
        this.authType = authType;
        this.server = server;
        this.username = username;
        this.password = password;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public void setProxyCredentials(String proxyServer, String proxyUsername, String proxyPassword, int proxyPort) {
        this.proxyServer = proxyServer;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.proxyPort = proxyPort;
    }

    static {
        serverPlatformURL.add("https://qualysguard.qualys.com");
        serverPlatformURL.add("https://qualysguard.qg2.apps.qualys.com");
        serverPlatformURL.add("https://qualysguard.qg3.apps.qualys.com");
        serverPlatformURL.add("https://qualysguard.qg4.apps.qualys.com");
        serverPlatformURL.add("https://qualysguard.qualys.eu");
        serverPlatformURL.add("https://qualysguard.qg2.apps.qualys.eu");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.in");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.ca");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.ae");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.co.uk");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.com.au");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualysksa.com");
        serverApiURL.add("https://qualysapi.qualys.com");
        serverApiURL.add("https://qualysapi.qg2.apps.qualys.com");
        serverApiURL.add("https://qualysapi.qg3.apps.qualys.com");
        serverApiURL.add("https://qualysapi.qg4.apps.qualys.com");
        serverApiURL.add("https://qualysapi.qualys.eu");
        serverApiURL.add("https://qualysapi.qg2.apps.qualys.eu");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.in");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.ca");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.ae");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.co.uk");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.com.au");
        serverApiURL.add("https://qualysapi.qg1.apps.qualysksa.com");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg2.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg3.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg4.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.eu");
        serverGatewayURL.add("https://gateway.qg2.apps.qualys.eu");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.in");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.ca");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.ae");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.co.uk");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.com.au");
        serverGatewayURL.add("https://gateway.qg1.apps.qualysksa.com");
    }
}

