/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.qmetry.CreateZip;
import com.qmetry.QMetryConnection;
import com.qmetry.QMetryException;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class QMetryResultUtil {
    private boolean onSlave = false;
    private File qtmFile;

    public boolean isOnSlave() {
        return this.onSlave;
    }

    public File getQtmFile() {
        return this.qtmFile;
    }

    public File prepareResultFile(String filePath, Run<?, ?> run, String pluginName, TaskListener listener, FilePath workspace, String automationFramework) throws QMetryException, IOException, InterruptedException {
        Computer comp1;
        Node node;
        Computer comp;
        this.onSlave = false;
        this.qtmFile = null;
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1, filePath.length());
        }
        if (filePath.endsWith("*.xml")) {
            filePath = filePath.substring(0, filePath.length() - 5);
        } else if (filePath.endsWith("*.json")) {
            filePath = filePath.substring(0, filePath.length() - 6);
        }
        if (workspace != null && (comp = workspace.toComputer()) != null && (node = comp.getNode()) != null && (comp1 = node.toComputer()) != null) {
            if (comp1 instanceof SlaveComputer) {
                File finalResultFile;
                int fileCount;
                AbstractProject project;
                this.onSlave = true;
                listener.getLogger().println(pluginName + " : build taking place on slave machine");
                FilePath slaveMachineWorkspace = workspace;
                if (!slaveMachineWorkspace.exists()) {
                    throw new QMetryException("Failed to access slave machine workspace directory");
                }
                FilePath f = null;
                if (automationFramework.equals("QAS")) {
                    File absoluteFile = new File(slaveMachineWorkspace.toString(), filePath);
                    if (absoluteFile.isFile()) {
                        f = new FilePath(slaveMachineWorkspace, filePath);
                        if (!f.exists()) {
                            throw new QMetryException("Can not find given file : " + f);
                        }
                    } else if (absoluteFile.isDirectory()) {
                        listener.getLogger().println(pluginName + " : Getting latest test-result folder for QAS...");
                        f = QMetryResultUtil.lastFileModified(slaveMachineWorkspace, filePath);
                        filePath = filePath + "/" + f.getName();
                        listener.getLogger().println(pluginName + " : Latest test-result folder : " + f.toString());
                    }
                } else {
                    f = new FilePath(slaveMachineWorkspace, filePath);
                    if (!f.exists()) {
                        throw new QMetryException("Can not find given file : " + f);
                    }
                }
                FilePath masterMachineWorkspace = null;
                if (run.getParent() instanceof AbstractProject) {
                    project = (AbstractProject)run.getParent();
                    masterMachineWorkspace = project.getCustomWorkspace() != null && project.getCustomWorkspace().length() > 0 ? new FilePath(new File(project.getCustomWorkspace())) : Jenkins.getInstance().getWorkspaceFor((TopLevelItem)project);
                } else if (run.getParent() instanceof WorkflowJob) {
                    project = (WorkflowJob)run.getParent();
                    masterMachineWorkspace = Jenkins.getInstance().getWorkspaceFor((TopLevelItem)project);
                }
                if (masterMachineWorkspace == null) {
                    throw new QMetryException("Failed to access master machine workspace directory");
                }
                if (!masterMachineWorkspace.exists()) {
                    masterMachineWorkspace.mkdirs();
                }
                masterMachineWorkspace = new FilePath(masterMachineWorkspace, "QTM");
                if (!(filePath.endsWith("/") || filePath.endsWith("json") || filePath.endsWith("xml"))) {
                    filePath = filePath + "/";
                }
                if ((fileCount = slaveMachineWorkspace.copyRecursiveTo(filePath, masterMachineWorkspace)) < 1) {
                    throw new QMetryException("Failed to copy result file(s) from slave machine!");
                }
                this.qtmFile = finalResultFile = new File(masterMachineWorkspace.toURI());
                if (!(finalResultFile = new File(finalResultFile, filePath)).exists()) {
                    throw new QMetryException("Failed to read result file(s) on master machine");
                }
                return finalResultFile;
            }
            if (comp1 instanceof Hudson.MasterComputer) {
                this.onSlave = false;
                listener.getLogger().println(pluginName + " : build taking place on master machine");
                File masterWorkspace = new File(workspace.toString());
                File absoluteFile = new File(masterWorkspace, filePath);
                FilePath resultFilePath = null;
                if (automationFramework.equals("QAS") && absoluteFile.isDirectory()) {
                    listener.getLogger().println(pluginName + " : Getting latest test-result folder for QAS...");
                    resultFilePath = QMetryResultUtil.lastFileModified(new FilePath(masterWorkspace), filePath);
                    listener.getLogger().println(pluginName + " : Latest test-result folder : " + resultFilePath.toString());
                } else {
                    resultFilePath = new FilePath(absoluteFile);
                    if (!resultFilePath.exists()) {
                        throw new QMetryException("Can not find given file : " + resultFilePath);
                    }
                }
                File resultFile = new File(resultFilePath.toString());
                if (!resultFile.exists()) {
                    throw new QMetryException("Result file(s) not found : '" + filePath + "'");
                }
                return resultFile;
            }
        }
        throw new QMetryException("Machine instance neither a master nor a slave");
    }

    public void uploadResultFilesToQMetry(Run<?, ?> run, String pluginName, TaskListener listener, FilePath workspace, String url, String key, String proxyUrl, String resultFilePath, String testSuiteName, String testSName, String tsFolderPath, String automationFramework, String automationHierarchy, String buildName, String platformName, String project, String release, String cycle, int buildnumber, String testCaseField, String testSuiteField, String skipWarning, String isMatchingRequired) throws Exception {
        File resultFile = this.prepareResultFile(resultFilePath, run, pluginName, listener, workspace, automationFramework);
        QMetryConnection conn = new QMetryConnection(url, key);
        if (automationFramework.equals("QAS") || resultFile.isDirectory()) {
            listener.getLogger().println(pluginName + " : Reading result files from path '" + resultFile.getAbsolutePath() + "'");
            String filepath = null;
            if (resultFile.isDirectory()) {
                filepath = CreateZip.createZip(resultFile.getAbsolutePath(), automationFramework);
                listener.getLogger().println(pluginName + " : Zip file path '" + filepath + "'");
            } else if (resultFile.isFile()) {
                String extension = "zip";
                String fileExtensionJson = QMetryResultUtil.getExtensionOfFile(resultFile);
                if (extension.equalsIgnoreCase(fileExtensionJson)) {
                    filepath = resultFile.getAbsolutePath();
                } else {
                    listener.getLogger().println(pluginName + " : Upload .Zip file or configure directory to upload " + automationFramework + " results");
                }
            }
            if (filepath == null) {
                throw new QMetryException("Results' directory of type " + automationFramework + " not found in given directory '" + resultFile.getAbsolutePath() + "'");
            }
            conn.uploadFileToTestSuite(filepath, testSuiteName, testSName, tsFolderPath, automationFramework, automationHierarchy, buildName, platformName, project, release, cycle, pluginName, listener, buildnumber, proxyUrl, testCaseField, testSuiteField, skipWarning, isMatchingRequired);
        } else if (resultFilePath.endsWith("*.xml") || resultFilePath.endsWith("*.json")) {
            FileFilter XML_FILE_FILTER = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".xml");
                }
            };
            FileFilter JSON_FILE_FILTER = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".json");
                }
            };
            File[] filelist = null;
            if (automationFramework.equals("JUNIT") || automationFramework.equals("TESTNG") || automationFramework.equals("HPUFT") || automationFramework.equals("ROBOT")) {
                if (resultFilePath.endsWith("*.json")) {
                    throw new QMetryException("Cannot upload json files when format is : " + automationFramework);
                }
                filelist = resultFile.listFiles(XML_FILE_FILTER);
            } else if (automationFramework.equals("CUCUMBER")) {
                if (resultFilePath.endsWith("*.xml")) {
                    throw new QMetryException("Cannot upload xml files when format is : " + automationFramework);
                }
                filelist = resultFile.listFiles(JSON_FILE_FILTER);
            }
            if (filelist == null) {
                throw new QMetryException("Cannot find files of proper format in directory : " + resultFile);
            }
            for (File f : filelist) {
                listener.getLogger().println(pluginName + " : Uploading file : " + f.getAbsolutePath() + "...");
                conn.uploadFileToTestSuite(f.getAbsolutePath(), testSuiteName, testSName, tsFolderPath, automationFramework, automationHierarchy, buildName, platformName, project, release, cycle, pluginName, listener, buildnumber, proxyUrl, testCaseField, testSuiteField, skipWarning, isMatchingRequired);
            }
        } else if (resultFile.isFile()) {
            String rPath = resultFile.getAbsolutePath();
            if (!(!rPath.endsWith(".xml") || automationFramework.equals("JUNIT") || automationFramework.equals("HPUFT") || automationFramework.equals("TESTNG") || automationFramework.equals("ROBOT"))) {
                throw new QMetryException("Cannot upload xml file when format is " + automationFramework);
            }
            if (rPath.endsWith(".json") && !automationFramework.equals("CUCUMBER")) {
                throw new QMetryException("Cannot upload json file when format is " + automationFramework);
            }
            listener.getLogger().println(pluginName + " : Reading result files from path '" + resultFile.getAbsolutePath() + "'");
            conn.uploadFileToTestSuite(rPath, testSuiteName, testSName, tsFolderPath, automationFramework, automationHierarchy, buildName, platformName, project, release, cycle, pluginName, listener, buildnumber, proxyUrl, testCaseField, testSuiteField, skipWarning, isMatchingRequired);
        } else {
            throw new QMetryException("Failed to read result file(s) at location '" + resultFile.getAbsolutePath() + "'");
        }
    }

    private static String getExtensionOfFile(File file) {
        String fileExtension = "";
        String fileName = file.getName();
        if (fileName.contains(".") && fileName.lastIndexOf(".") != 0) {
            fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return fileExtension;
    }

    public static FilePath lastFileModified(FilePath base, String path) throws IOException, InterruptedException, QMetryException {
        FilePath slaveDir = new FilePath(base, path);
        if (!slaveDir.exists()) {
            throw new QMetryException("Cannot find given file : " + slaveDir);
        }
        List files = slaveDir.listDirectories();
        long lastMod = Long.MIN_VALUE;
        FilePath choice = null;
        if (files != null) {
            for (FilePath file : files) {
                if (!file.isDirectory() || file.getName().equals("surefire") || file.lastModified() <= lastMod) continue;
                choice = file;
                lastMod = file.lastModified();
            }
        }
        if (choice == null) {
            throw new QMetryException("Cannot find latest test-result files for QAS");
        }
        return choice;
    }
}

