/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.qmetry.CreateZip;
import com.qmetry.FindFile;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@IgnoreJRERequirement
public class UploadToServerV4 {
    public Map<String, String> uploadToTheServer(String jiraUrlServer, String username_chkd, Secret password_chkd, String apikey, String file, boolean attachFile, Boolean matchTestSteps, String format, String testCycleToReuse, String environment, String build, String testCycleLabels, String testCycleComponents, String testCyclePriority, String testCycleStatus, String testCycleSprintId, String testCycleFixVersionId, String testCycleSummary, String testCycleCustomFields, String testCycleDescription, String testCycleAssignee, String testCycleReporter, String testCycleStartDate, String testCycleEndDate, String testCaseDescription, String testCaseAssignee, String testCaseReporter, String testCaseEstimatedTime, String testCaseLabels, String testCaseComponents, String testCasePriority, String testCaseStatus, String testCaseSprintId, String testCaseFixVersionId, String testCaseCustomFields, int buildnumber, Run<?, ?> run, TaskListener listener, FilePath workspace, String pluginName, String serverAuthenticationType, String personalAccessToken, String testCycleFolderPath, String testCaseFolderPath, String testCasePrecondition, String testCaseExecutionComment, String testCaseExecutionActualTime, String testCaseExecutionAssignee, String testCaseExecutionCustomFields, String testCaseExecutionPlannedDate, String automationHierarchy, String appendTestName) throws MalformedURLException, IOException, UnsupportedEncodingException, ProtocolException, ParseException, FileNotFoundException, InterruptedException {
        JSONArray mJSONArray;
        JSONArray mJSONArray2;
        PrintStream logger = listener.getLogger();
        File resultFile = FindFile.findFile(file, run, listener, format, workspace);
        if (resultFile == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (jiraUrlServer != null && jiraUrlServer.length() > 0 && jiraUrlServer.charAt(jiraUrlServer.length() - 1) == '/') {
            jiraUrlServer = jiraUrlServer.substring(0, jiraUrlServer.length() - 1);
        }
        String uploadserverurlv4 = jiraUrlServer + "/rest/qtm4j/automation/latest/importresult";
        String auth = "";
        if (serverAuthenticationType.equalsIgnoreCase("BASICAUTH")) {
            String toEncode = username_chkd.trim() + ":" + password_chkd.getPlainText().trim();
            byte[] mes = toEncode.getBytes("UTF-8");
            String encodedString = DatatypeConverter.printBase64Binary((byte[])mes);
            auth = "Basic " + encodedString;
        } else {
            auth = "Bearer " + personalAccessToken;
        }
        logger.println(pluginName + "Server_Authentication_Type : " + serverAuthenticationType);
        String encoding = "UTF-8";
        URL url = new URL(uploadserverurlv4);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setRequestProperty("apiKey", apikey.trim());
        connection.setRequestProperty("Authorization", auth);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        String filepath = "";
        boolean iszip = false;
        if (resultFile.isDirectory()) {
            iszip = true;
            logger.println(pluginName + "Given Path is Directory.");
            logger.println(pluginName + "Creating Zip...");
            filepath = CreateZip.createZip(resultFile.getAbsolutePath(), format, attachFile);
            logger.println(pluginName + "Zip file path : " + filepath);
        } else {
            filepath = resultFile.getAbsolutePath();
            String fileExtension = "";
            if (filepath.contains(".") && filepath.lastIndexOf(".") != 0) {
                fileExtension = filepath.substring(filepath.lastIndexOf(".") + 1);
            }
            if (fileExtension.equals("zip")) {
                iszip = true;
            }
        }
        HashMap<String, Object> requestDataMap = new HashMap<String, Object>();
        String format_short = "";
        if (String.valueOf(format).equals("testng/xml")) {
            format_short = "testng";
        } else if (String.valueOf(format).equals("junit/xml")) {
            format_short = "junit";
        } else if (String.valueOf(format).equals("qas/json")) {
            format_short = "qaf";
        } else if (String.valueOf(format).equals("cucumber/json")) {
            format_short = "cucumber";
        } else if (String.valueOf(format).equals("hpuft/xml")) {
            format_short = "hpuft";
        } else if (String.valueOf(format).equals("specflow/json")) {
            format_short = "specflow";
        }
        if (format.equals("junit/xml") || format.equals("testng/xml")) {
            if (automationHierarchy != null && !automationHierarchy.isEmpty() && !automationHierarchy.equals("default")) {
                requestDataMap.put("automationHierarchy", Integer.parseInt(automationHierarchy));
            }
            if (!(appendTestName == null || appendTestName.isEmpty() || Objects.equals(automationHierarchy, "1") || appendTestName.equals("default"))) {
                requestDataMap.put("appendTestName", Boolean.parseBoolean(appendTestName));
            }
        }
        requestDataMap.put("format", String.valueOf(format_short));
        requestDataMap.put("isZip", String.valueOf(iszip));
        if (attachFile) {
            requestDataMap.put("attachFile", String.valueOf(attachFile));
        }
        requestDataMap.put("matchTestSteps", matchTestSteps);
        if (testCycleToReuse != null && !testCycleToReuse.isEmpty()) {
            requestDataMap.put("testCycleToReuse", testCycleToReuse.trim());
        }
        if (environment != null && !environment.isEmpty()) {
            requestDataMap.put("environment", environment.trim());
        }
        if (build != null && !build.isEmpty()) {
            requestDataMap.put("build", build.trim());
        }
        HashMap<String, Object> testcycleDataMap = new HashMap<String, Object>();
        boolean isTestcycle = false;
        if (testCycleLabels != null && !testCycleLabels.isEmpty()) {
            isTestcycle = true;
            mJSONArray2 = this.commaSepratedStringtoJson(testCycleLabels);
            testcycleDataMap.put("labels", mJSONArray2);
        }
        if (testCycleComponents != null && !testCycleComponents.isEmpty()) {
            isTestcycle = true;
            mJSONArray2 = this.commaSepratedStringtoJson(testCycleComponents);
            testcycleDataMap.put("components", mJSONArray2);
        }
        if (testCyclePriority != null && !testCyclePriority.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("priority", testCyclePriority.trim());
        }
        if (testCycleStatus != null && !testCycleStatus.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("status", testCycleStatus.trim());
        }
        if (testCycleSprintId != null && !testCycleSprintId.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("sprintId", testCycleSprintId.trim());
        }
        if (testCycleFixVersionId != null && !testCycleFixVersionId.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("fixVersionId", testCycleFixVersionId.trim());
        }
        if (testCycleSummary != null && !testCycleSummary.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("summary", testCycleSummary.trim() + "_" + buildnumber);
        }
        if (testCycleDescription != null && !testCycleDescription.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("description", testCycleDescription.trim());
        }
        if (testCycleStartDate != null && !testCycleStartDate.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("plannedStartDate", testCycleStartDate.trim());
        }
        if (testCycleEndDate != null && !testCycleEndDate.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("plannedEndDate", testCycleEndDate.trim());
        }
        if (testCycleAssignee != null && !testCycleAssignee.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("assignee", testCycleAssignee.trim());
        }
        if (testCycleReporter != null && !testCycleReporter.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("reporter", testCycleReporter.trim());
        }
        if (testCycleFolderPath != null && !testCycleFolderPath.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("folderPath", testCycleFolderPath.trim());
        }
        if (testCycleCustomFields != null && !testCycleCustomFields.isEmpty()) {
            isTestcycle = true;
            JSONParser parser = new JSONParser();
            org.json.simple.JSONArray testcycleCustomFieldsJson = (org.json.simple.JSONArray)parser.parse(testCycleCustomFields);
            testcycleDataMap.put("customFields", testcycleCustomFieldsJson);
        }
        HashMap<String, Object> testcaseDataMap = new HashMap<String, Object>();
        boolean isTestcase = false;
        if (testCaseLabels != null && !testCaseLabels.isEmpty()) {
            isTestcase = true;
            mJSONArray = this.commaSepratedStringtoJson(testCaseLabels);
            testcaseDataMap.put("labels", mJSONArray);
        }
        if (testCaseComponents != null && !testCaseComponents.isEmpty()) {
            isTestcase = true;
            mJSONArray = this.commaSepratedStringtoJson(testCaseComponents);
            testcaseDataMap.put("components", mJSONArray);
        }
        if (testCasePriority != null && !testCasePriority.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("priority", testCasePriority.trim());
        }
        if (testCaseStatus != null && !testCaseStatus.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("status", testCaseStatus.trim());
        }
        if (testCaseSprintId != null && !testCaseSprintId.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("sprintId", testCaseSprintId.trim());
        }
        if (testCaseFixVersionId != null && !testCaseFixVersionId.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("fixVersionId", testCaseFixVersionId.trim());
        }
        if (testCaseDescription != null && !testCaseDescription.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("description", testCaseDescription.trim());
        }
        if (testCaseAssignee != null && !testCaseAssignee.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("assignee", testCaseAssignee.trim());
        }
        if (testCaseReporter != null && !testCaseReporter.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("reporter", testCaseReporter.trim());
        }
        if (testCaseEstimatedTime != null && !testCaseEstimatedTime.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("estimatedTime", testCaseEstimatedTime.trim());
        }
        if (testCaseFolderPath != null && !testCaseFolderPath.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("folderPath", testCaseFolderPath.trim());
        }
        if (testCasePrecondition != null && !testCasePrecondition.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("precondition", testCasePrecondition.trim());
        }
        if (testCaseCustomFields != null && !testCaseCustomFields.isEmpty()) {
            isTestcase = true;
            JSONParser parser = new JSONParser();
            org.json.simple.JSONArray testcaseCustomFieldsJson = (org.json.simple.JSONArray)parser.parse(testCaseCustomFields);
            testcaseDataMap.put("customFields", testcaseCustomFieldsJson);
        }
        HashMap<String, String> testCaseExecutionDataMap = new HashMap<String, String>();
        boolean isTestCaseExecution = false;
        if (testCaseExecutionComment != null && !testCaseExecutionComment.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("comment", testCaseExecutionComment.trim());
        }
        if (testCaseExecutionActualTime != null && !testCaseExecutionActualTime.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("actualTime", testCaseExecutionActualTime.trim());
        }
        if (testCaseExecutionAssignee != null && !testCaseExecutionAssignee.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("assignee", testCaseExecutionAssignee.trim());
        }
        if (testCaseExecutionCustomFields != null && !testCaseExecutionCustomFields.isEmpty()) {
            isTestCaseExecution = true;
            JSONParser parser = new JSONParser();
            org.json.simple.JSONArray testCaseExecutionCustomFieldsJson = (org.json.simple.JSONArray)parser.parse(testCaseExecutionCustomFields);
            testCaseExecutionDataMap.put("customFields", (String)testCaseExecutionCustomFieldsJson);
        }
        if (testCaseExecutionPlannedDate != null && !testCaseExecutionPlannedDate.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("executionPlannedDate", testCaseExecutionPlannedDate.trim());
        }
        HashMap<String, HashMap<String, Object>> testCaseCycleTcExecutionDataMap = new HashMap<String, HashMap<String, Object>>();
        if (isTestcycle) {
            testCaseCycleTcExecutionDataMap.put("testCycle", testcycleDataMap);
            logger.println(pluginName + "TestCycle  : " + testcycleDataMap);
        }
        if (isTestcase) {
            testCaseCycleTcExecutionDataMap.put("testCase", testcaseDataMap);
            logger.println(pluginName + "TestCase : " + testcaseDataMap);
        }
        if (isTestCaseExecution) {
            testCaseCycleTcExecutionDataMap.put("testCaseExecution", testCaseExecutionDataMap);
            logger.println(pluginName + "TestCaseExecution : " + testCaseExecutionDataMap);
        }
        requestDataMap.put("fields", testCaseCycleTcExecutionDataMap);
        JSONObject jsonbody = new JSONObject(requestDataMap);
        logger.println(pluginName + "JsonBody : " + jsonbody);
        OutputStream os = connection.getOutputStream();
        os.write(jsonbody.toString().getBytes("UTF-8"));
        int statusCode = connection.getResponseCode();
        logger.println(pluginName + "Generate URL API response code : " + statusCode);
        InputStream fis = null;
        fis = statusCode >= 200 && statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        StringWriter response = new StringWriter();
        IOUtils.copy((InputStream)fis, (Writer)response, (String)encoding);
        JSONParser parser = new JSONParser();
        logger.println(pluginName + "Generate URL API response : " + response.toString());
        JSONObject obj = (JSONObject)parser.parse(response.toString());
        if (obj != null) {
            String resUrl = (String)obj.get((Object)"url");
            if (resUrl != null && !resUrl.isEmpty()) {
                String res = this.uploadToS3(response.toString(), filepath, apikey, auth, logger, pluginName, jiraUrlServer);
                map.put("success", "true");
                map.put("message", res);
            } else {
                map.put("success", "false");
                map.put("errorMessage", response.toString());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadToS3(String response, String fileurl, String apiKey, String auth, PrintStream logger, String pluginName, String jiraUrlServer) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(response);
        JSONObject jsonObject = (JSONObject)obj;
        String urlForUpload = (String)jsonObject.get((Object)"url");
        String trackingId = (String)jsonObject.get((Object)"trackingId");
        String uploadResponseString = "";
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(urlForUpload);
            httppost.addHeader("apikey", apiKey);
            httppost.addHeader("Authorization", auth);
            FileBody fileBody = new FileBody(new File(fileurl));
            HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)fileBody).build();
            httppost.setEntity(reqEntity);
            try (CloseableHttpResponse uploadResponse = httpclient.execute((HttpUriRequest)httppost);){
                int statusCode = uploadResponse.getStatusLine().getStatusCode();
                logger.println(pluginName + "File upload status code : " + uploadResponse.getStatusLine().getStatusCode());
                if (statusCode == 204) {
                    logger.println(pluginName + "File uploaded successfully.");
                    uploadResponseString = this.checkStatus(jiraUrlServer, trackingId, apiKey, auth, logger, pluginName);
                } else {
                    uploadResponseString = "false";
                }
            }
        }
        return uploadResponseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkStatus(String jiraUrlServer, String trackingId, String apiKey, String auth, PrintStream logger, String pluginName) {
        String trackUrl = jiraUrlServer + "/rest/qtm4j/automation/latest/importresult/track?trackingId=" + trackingId;
        String trackResponseString = "";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(trackUrl);
            httpGet.addHeader("apikey", apiKey);
            httpGet.addHeader("Authorization", auth);
            httpGet.addHeader("Content-Type", "application/json");
            CloseableHttpResponse trackResponse = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = trackResponse.getEntity();
            trackResponseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            try {
                int statusCode = trackResponse.getStatusLine().getStatusCode();
                logger.println(pluginName + "Progress response code : " + statusCode);
            }
            catch (Exception e) {
                trackResponseString = e.getMessage();
            }
            finally {
                trackResponse.getEntity().getContent().close();
            }
        }
        catch (Exception e) {
            trackResponseString = e.getMessage();
        }
        return trackResponseString;
    }

    public JSONArray commaSepratedStringtoJson(String commaSeparatedString) {
        String[] arrayStr = commaSeparatedString.split(",");
        JSONArray mJSONArray = new JSONArray();
        for (String s : arrayStr) {
            mJSONArray.put((Object)s.trim());
        }
        return mJSONArray;
    }
}

