/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.qmetry.FindFile;
import com.qmetry.UploadToCloud;
import com.qmetry.UploadToServer;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.InvalidCredentialsException;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.parser.ParseException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@IgnoreJRERequirement
public class TestReportDeployPublisher
extends Recorder
implements SimpleBuildStep {
    private boolean disableaction;
    private boolean attachFile;
    private boolean attachFileServer;
    private String name;
    private String version;
    private String apikey;
    private String file;
    private String testrunname;
    private String testrunkey;
    private String testassethierarchy;
    private String testCaseUpdateLevel;
    private String labels;
    private String sprint;
    private String component;
    private String format;
    private String platform;
    private String comment;
    private String jirafields;
    private String apikeyserver;
    private String jiraurlserver;
    private String proxyUrl;
    private String username;
    private Secret password;
    private String testrunnameserver;
    private String testrunkeyserver;
    private String testassethierarchyserver;
    private String testCaseUpdateLevelServer;
    private String labelsserver;
    private String sprintserver;
    private String versionserver;
    private String componentserver;
    private String platformserver;
    private String commentserver;
    private String fileserver;
    private String formatserver;
    private String jirafieldsserver;
    public String testToRun;
    public String serverAuthenticationType;
    private String personalAccessToken;

    public String getPlatformserver() {
        return this.platformserver;
    }

    public void setPlatformserver(String platformserver) {
        this.platformserver = platformserver;
    }

    public String getCommentserver() {
        return this.commentserver;
    }

    public void setCommentserver(String commentserver) {
        this.commentserver = commentserver;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormatserver() {
        return this.formatserver;
    }

    public void setFormatserver(String formatserver) {
        this.formatserver = formatserver;
    }

    public String getFileserver() {
        return this.fileserver;
    }

    public void setFileserver(String fileserver) {
        this.fileserver = fileserver;
    }

    public String getApikeyserver() {
        return Secret.toString((Secret)Secret.fromString((String)this.apikeyserver));
    }

    public void setApikeyserver(String apikeyserver) {
        this.apikeyserver = Secret.fromString((String)apikeyserver).getEncryptedValue();
    }

    public String getJiraurlserver() {
        return this.jiraurlserver;
    }

    public void setJiraurlserver(String jiraurlserver) {
        this.jiraurlserver = jiraurlserver;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public String getServerAuthenticationType() {
        return this.serverAuthenticationType;
    }

    public void setServerAuthenticationType(String serverAuthenticationType) {
        this.serverAuthenticationType = serverAuthenticationType;
    }

    public String getPersonalAccessToken() {
        return this.personalAccessToken;
    }

    public void setPersonalAccessToken(String personalAccessToken) {
        this.personalAccessToken = personalAccessToken;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getTestrunnameserver() {
        return this.testrunnameserver;
    }

    public void setTestrunnameserver(String testrunnameserver) {
        this.testrunnameserver = testrunnameserver;
    }

    public String getLabelsserver() {
        return this.labelsserver;
    }

    public void setLabelsserver(String labelsserver) {
        this.labelsserver = labelsserver;
    }

    public String getSprintserver() {
        return this.sprintserver;
    }

    public void setSprintserver(String sprintserver) {
        this.sprintserver = sprintserver;
    }

    public String getVersionserver() {
        return this.versionserver;
    }

    public void setVersionserver(String versionserver) {
        this.versionserver = versionserver;
    }

    public String getComponentserver() {
        return this.componentserver;
    }

    public void setComponentserver(String componentserver) {
        this.componentserver = componentserver;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getApikey() {
        return Secret.toString((Secret)Secret.fromString((String)this.apikey));
    }

    public void setApikey(String apikey) {
        this.apikey = Secret.fromString((String)apikey).getEncryptedValue();
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getTestrunname() {
        return this.testrunname;
    }

    public void setTestrunname(String testrunname) {
        this.testrunname = testrunname;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getSprint() {
        return this.sprint;
    }

    public void setSprint(String sprint) {
        this.sprint = sprint;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getTestrunkey() {
        return this.testrunkey;
    }

    public void setTestrunkey(String testrunkey) {
        this.testrunkey = testrunkey;
    }

    public String getTestrunkeyserver() {
        return this.testrunkeyserver;
    }

    public void setTestrunkeyserver(String testrunkeyserver) {
        this.testrunkeyserver = testrunkeyserver;
    }

    public String getTestassethierarchy() {
        return this.testassethierarchy;
    }

    public void setTestassethierarchy(String testassethierarchy) {
        this.testassethierarchy = testassethierarchy;
    }

    public String getTestassethierarchyserver() {
        return this.testassethierarchyserver;
    }

    public void setTestassethierarchyserver(String testassethierarchyserver) {
        this.testassethierarchyserver = testassethierarchyserver;
    }

    public String getTestCaseUpdateLevel() {
        return this.testCaseUpdateLevel;
    }

    public void setTestCaseUpdateLevel(String testCaseUpdateLevel) {
        this.testCaseUpdateLevel = testCaseUpdateLevel;
    }

    public String getTestCaseUpdateLevelServer() {
        return this.testCaseUpdateLevelServer;
    }

    public void setTestCaseUpdateLevelServer(String testCaseUpdateLevelServer) {
        this.testCaseUpdateLevelServer = testCaseUpdateLevelServer;
    }

    public String getJirafields() {
        return this.jirafields;
    }

    public void setJirafields(String jirafields) {
        this.jirafields = jirafields;
    }

    public String getJirafieldsserver() {
        return this.jirafieldsserver;
    }

    public void setJirafieldsserver(String jirafieldsserver) {
        this.jirafieldsserver = jirafieldsserver;
    }

    public boolean isDisableaction() {
        return this.disableaction;
    }

    public boolean isAttachFile() {
        return this.attachFile;
    }

    public boolean isAttachFileServer() {
        return this.attachFileServer;
    }

    public TestReportDeployPublisher() {
    }

    @DataBoundConstructor
    public TestReportDeployPublisher(String name, String apikey, String file, boolean attachFile, String testrunname, String labels, String sprint, String version, String component, String format, String platform, String comment, String apikeyserver, String jiraurlserver, String proxyUrl, Secret password, String testrunnameserver, String labelsserver, String sprintserver, String versionserver, String componentserver, String username, String fileserver, boolean attachFileServer, String formatserver, String platformserver, String commentserver, String testToRun, String testrunkey, String testassethierarchy, String testCaseUpdateLevel, String jirafields, String testrunkeyserver, String testassethierarchyserver, String testCaseUpdateLevelServer, String jirafieldsserver, boolean disableaction, String serverAuthenticationType, String personalAccessToken) throws AbortException {
        this.disableaction = disableaction;
        this.attachFile = attachFile;
        this.attachFileServer = attachFileServer;
        this.version = version;
        if (apikey != null && !apikey.isEmpty()) {
            Secret ak = Secret.fromString((String)apikey);
            this.apikey = ak.getEncryptedValue();
        }
        this.file = file;
        this.testrunname = testrunname;
        this.labels = labels;
        this.sprint = sprint;
        this.component = component;
        this.format = format;
        this.platform = platform;
        this.comment = comment;
        this.testrunkey = testrunkey;
        this.testassethierarchy = testassethierarchy;
        this.testCaseUpdateLevel = testCaseUpdateLevel;
        this.jirafields = jirafields;
        if (apikeyserver != null && !apikeyserver.isEmpty()) {
            Secret aps = Secret.fromString((String)apikeyserver);
            this.apikeyserver = aps.getEncryptedValue();
        }
        this.jiraurlserver = jiraurlserver;
        this.proxyUrl = proxyUrl;
        this.password = password;
        this.testrunnameserver = testrunnameserver;
        this.labelsserver = labelsserver;
        this.sprintserver = sprintserver;
        this.versionserver = versionserver;
        this.componentserver = componentserver;
        this.username = username;
        this.fileserver = fileserver;
        this.formatserver = formatserver;
        this.platformserver = platformserver;
        this.commentserver = commentserver;
        this.testrunkeyserver = testrunkeyserver;
        this.testassethierarchyserver = testassethierarchyserver;
        this.testCaseUpdateLevelServer = testCaseUpdateLevelServer;
        this.jirafieldsserver = jirafieldsserver;
        this.testToRun = testToRun;
        this.serverAuthenticationType = serverAuthenticationType;
        this.personalAccessToken = personalAccessToken;
    }

    public String isTestType(String testTypeName) {
        return this.testToRun.equalsIgnoreCase(testTypeName) ? "true" : "";
    }

    public String isServerAuthenticationType(String authenticationType) {
        if (this.serverAuthenticationType == null) {
            this.serverAuthenticationType = "BASICAUTH";
        }
        return this.serverAuthenticationType.equalsIgnoreCase(authenticationType) ? "true" : "";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String pluginName = "QMetry for JIRA : ";
        int buildnumber = run.number;
        PrintStream logger = listener.getLogger();
        if (this.disableaction) {
            logger.println(pluginName + "Action 'Publish test result to QMetry for JIRA' is disabled");
            return;
        }
        EnvVars env = null;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment variables: " + e.getMessage());
        }
        switch (this.testToRun) {
            case "CLOUD": {
                UploadToCloud uploadToCloud = new UploadToCloud();
                logger.println("--------------------------------------------------------");
                logger.println(pluginName + "Uploading result file(s) to JIRA Cloud");
                logger.println("--------------------------------------------------------");
                String file_chkd = env.expand(this.getFile());
                String format_chkd = env.expand(this.getFormat());
                String testrunname_chkd = env.expand(this.getTestrunname());
                String testrunkey_chkd = env.expand(this.getTestrunkey());
                String testassethierarchy_chkd = env.expand(this.getTestassethierarchy());
                String labels_chkd = env.expand(this.getLabels());
                String sprint_chkd = env.expand(this.getSprint());
                String version_chkd = env.expand(this.getVersion());
                String component_chkd = env.expand(this.getComponent());
                String comment_chkd = env.expand(this.getComment());
                String platform_chkd = env.expand(this.getPlatform());
                String jirafields_chkd = env.expand(this.getJirafields());
                String apikey_chkd = env.expand(this.getApikey());
                if (apikey_chkd == null || apikey_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter API Key.");
                    throw new AbortException();
                }
                if (file_chkd == null || file_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter path to the test result files.");
                    throw new AbortException();
                }
                if (format_chkd == null || format_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter format for test result files.");
                    throw new AbortException();
                }
                logger.println(pluginName + "File Path : " + file_chkd);
                logger.println(pluginName + "Format : " + format_chkd);
                if (testrunname_chkd != null && !testrunname_chkd.isEmpty()) {
                    logger.println(pluginName + "Testrun Name : " + testrunname_chkd);
                }
                if (testrunkey_chkd != null && !testrunkey_chkd.isEmpty()) {
                    logger.println(pluginName + "Testrun key : " + testrunkey_chkd);
                }
                if (testassethierarchy_chkd != null && !testassethierarchy_chkd.isEmpty()) {
                    logger.println(pluginName + "Test asset hierarchy : " + testassethierarchy_chkd);
                }
                if (this.testCaseUpdateLevel != null && !this.testCaseUpdateLevel.isEmpty()) {
                    logger.println(pluginName + "Testcase update level : " + this.testCaseUpdateLevel);
                }
                if (labels_chkd != null && !labels_chkd.isEmpty()) {
                    logger.println(pluginName + "Labels : " + labels_chkd);
                }
                if (sprint_chkd != null && !sprint_chkd.isEmpty()) {
                    logger.println(pluginName + "Sprint : " + sprint_chkd);
                }
                if (version_chkd != null && !version_chkd.isEmpty()) {
                    logger.println(pluginName + "Version : " + version_chkd);
                }
                if (component_chkd != null && !component_chkd.isEmpty()) {
                    logger.println(pluginName + "Component : " + this.getComponent());
                }
                if (platform_chkd != null && !platform_chkd.isEmpty()) {
                    logger.println(pluginName + "Platform : " + platform_chkd);
                }
                if (comment_chkd != null && !comment_chkd.isEmpty()) {
                    logger.println(pluginName + "Comment : " + this.getComment());
                }
                if (jirafields_chkd != null && !jirafields_chkd.isEmpty()) {
                    logger.println(pluginName + "JIRA fields : " + jirafields_chkd);
                }
                try {
                    Map<String, String> response = uploadToCloud.uploadToTheCloud(apikey_chkd, file_chkd.trim().replace("\\", "/"), this.attachFile, testrunname_chkd, labels_chkd, sprint_chkd, version_chkd, component_chkd, format_chkd, platform_chkd, comment_chkd, testrunkey_chkd, testassethierarchy_chkd, this.testCaseUpdateLevel, jirafields_chkd, buildnumber, run, listener, workspace);
                    if (response == null) throw new AbortException();
                    if (!response.get("success").equals("true")) {
                        logger.println(pluginName + response.get("errorMessage"));
                        throw new AbortException();
                    }
                    if (response.get("message").equals("false")) {
                        logger.println(pluginName + "Error has occurred while uploading the file to temporary S3 bucket.");
                        throw new AbortException();
                    }
                    logger.println(pluginName + response.get("message"));
                }
                catch (MalformedURLException e) {
                    try {
                        if (e.getMessage() != null) {
                            logger.println(pluginName + "Exception Message: " + e.getMessage());
                        }
                        logger.println(pluginName + "[ERROR] : MalformedURLException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                        e.printStackTrace();
                        throw new AbortException();
                        catch (UnsupportedEncodingException e2) {
                            if (e2.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e2.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : UnsupportedEncodingException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e2.printStackTrace();
                            throw new AbortException();
                        }
                        catch (ProtocolException e3) {
                            if (e3.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e3.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : ProtocolException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e3.printStackTrace();
                            throw new AbortException();
                        }
                        catch (FileNotFoundException e4) {
                            if (e4.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e4.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : FileNotFoundException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e4.printStackTrace();
                            throw new AbortException();
                        }
                        catch (IOException e5) {
                            if (e5.getMessage() == null) throw new AbortException();
                            if (e5.getMessage().equals("CustomException")) throw new AbortException();
                            logger.println(pluginName + "Exception Message: " + e5.getMessage());
                            logger.println(pluginName + "[ERROR] : IOException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e5.printStackTrace();
                            throw new AbortException();
                        }
                        catch (ParseException e6) {
                            if (e6.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e6.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : ParseException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e6.printStackTrace();
                            throw new AbortException();
                        }
                        catch (Exception e7) {
                            e7.printStackTrace();
                            if (e7.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e7.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : GeneralException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            throw new AbortException();
                        }
                    }
                    catch (Throwable throwable) {
                        if (!FindFile.getOnSlave()) throw throwable;
                        if (FindFile.getQtm4jFile() == null) throw throwable;
                        try {
                            FileUtils.cleanDirectory((File)FindFile.getQtm4jFile());
                            throw throwable;
                        }
                        catch (IOException e8) {
                            listener.getLogger().println(pluginName + "Copying task failed");
                            throw throwable;
                        }
                        catch (IllegalArgumentException e9) {
                            listener.getLogger().println(pluginName + "Copying task failed");
                        }
                        throw throwable;
                    }
                }
                if (!FindFile.getOnSlave()) return;
                if (FindFile.getQtm4jFile() == null) return;
                try {
                    FileUtils.cleanDirectory((File)FindFile.getQtm4jFile());
                    return;
                }
                catch (IOException e) {
                    listener.getLogger().println(pluginName + "Copying task failed");
                    return;
                }
                catch (IllegalArgumentException e) {
                    listener.getLogger().println(pluginName + "Copying task failed");
                    return;
                }
            }
            case "SERVER": {
                UploadToServer uploadToServer = new UploadToServer();
                logger.println("---------------------------------------------------------");
                logger.println(pluginName + "Uploading result file(s) to JIRA Server");
                logger.println("---------------------------------------------------------");
                String file_chkd = env.expand(this.getFileserver());
                String format_chkd = env.expand(this.getFormatserver());
                String testrunname_chkd = env.expand(this.getTestrunnameserver());
                String testrunkey_chkd = env.expand(this.getTestrunkeyserver());
                String testassethierarchy_chkd = env.expand(this.getTestassethierarchyserver());
                String labels_chkd = env.expand(this.getLabelsserver());
                String sprint_chkd = env.expand(this.getSprintserver());
                String version_chkd = env.expand(this.getVersionserver());
                String component_chkd = env.expand(this.getComponentserver());
                String comment_chkd = env.expand(this.getCommentserver());
                String platform_chkd = env.expand(this.getPlatformserver());
                String jirafields_chkd = env.expand(this.getJirafieldsserver());
                String apikey_chkd = env.expand(this.getApikeyserver());
                String jiraurlserver_chkd = env.expand(this.getJiraurlserver());
                String proxyUrl_chkd = env.expand(this.getProxyUrl());
                String username_chkd = env.expand(this.getUsername());
                Secret password_chkd = Secret.fromString((String)env.expand(Secret.toString((Secret)this.getPassword())));
                String serverAuthenticationType_chkd = env.expand(this.getServerAuthenticationType());
                String personalAccessToken_chkd = env.expand(this.getPersonalAccessToken());
                if (jiraurlserver_chkd == null || jiraurlserver_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter JIRA URL for server instance.");
                    throw new AbortException();
                }
                if (serverAuthenticationType_chkd == null || serverAuthenticationType_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Select server authentication type.");
                    throw new AbortException();
                }
                if (serverAuthenticationType_chkd.equalsIgnoreCase("BASICAUTH")) {
                    if (username_chkd == null || username_chkd.isEmpty()) {
                        logger.println(pluginName + "[ERROR] : Enter Username for JIRA server instance.");
                        throw new AbortException();
                    }
                    if (password_chkd == null) {
                        logger.println(pluginName + "[ERROR] : Enter Password for JIRA server instance.");
                        throw new AbortException();
                    }
                } else if (personalAccessToken_chkd == null || personalAccessToken_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter Personal Access Token for JIRA server instance.");
                    throw new AbortException();
                }
                if (apikey_chkd == null || apikey_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter API Key for your project.");
                    throw new AbortException();
                }
                if (file_chkd == null || file_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter path to the test result files.");
                    throw new AbortException();
                }
                if (format_chkd == null || format_chkd.isEmpty()) {
                    logger.println(pluginName + "[ERROR] : Enter format for test result files.");
                    throw new AbortException();
                }
                logger.println(pluginName + "JIRA URL : " + jiraurlserver_chkd);
                logger.println(pluginName + "File Path : " + file_chkd);
                logger.println(pluginName + "Format : " + format_chkd);
                if (proxyUrl_chkd != null && !proxyUrl_chkd.isEmpty()) {
                    logger.println(pluginName + "Proxy URL : " + proxyUrl_chkd);
                }
                if (testrunname_chkd != null && !testrunname_chkd.isEmpty()) {
                    logger.println(pluginName + "Test run Name : " + testrunname_chkd);
                }
                if (testrunkey_chkd != null && !testrunkey_chkd.isEmpty()) {
                    logger.println(pluginName + "Test run Key : " + testrunkey_chkd);
                }
                if (testassethierarchy_chkd != null && !testassethierarchy_chkd.isEmpty()) {
                    logger.println(pluginName + "Test asset hierarchy : " + testassethierarchy_chkd);
                }
                if (this.testCaseUpdateLevelServer != null && !this.testCaseUpdateLevelServer.isEmpty()) {
                    logger.println(pluginName + "Test case update level : " + this.testCaseUpdateLevelServer);
                }
                if (labels_chkd != null && !labels_chkd.isEmpty()) {
                    logger.println(pluginName + "Labels : " + labels_chkd);
                }
                if (sprint_chkd != null && !sprint_chkd.isEmpty()) {
                    logger.println(pluginName + "Sprint : " + sprint_chkd);
                }
                if (version_chkd != null && !version_chkd.isEmpty()) {
                    logger.println(pluginName + "Version : " + version_chkd);
                }
                if (component_chkd != null && !component_chkd.isEmpty()) {
                    logger.println(pluginName + "Component : " + component_chkd);
                }
                if (platform_chkd != null && !platform_chkd.isEmpty()) {
                    logger.println(pluginName + "Platform : " + platform_chkd);
                }
                if (comment_chkd != null && !comment_chkd.isEmpty()) {
                    logger.println(pluginName + "Comment : " + comment_chkd);
                }
                if (jirafields_chkd != null && !jirafields_chkd.isEmpty()) {
                    logger.println(pluginName + "JIRA Fields :" + jirafields_chkd);
                }
                try {
                    Map<String, String> response = uploadToServer.uploadToTheServer(apikey_chkd, jiraurlserver_chkd, proxyUrl_chkd, password_chkd, testrunname_chkd, labels_chkd, sprint_chkd, version_chkd, component_chkd, username_chkd, file_chkd.trim().replace("\\", "/"), this.attachFileServer, format_chkd, platform_chkd, comment_chkd, testrunkey_chkd, testassethierarchy_chkd, this.testCaseUpdateLevelServer, jirafields_chkd, buildnumber, run, listener, workspace, pluginName, serverAuthenticationType_chkd, personalAccessToken_chkd);
                    if (response == null) throw new AbortException();
                    if (response.get("success").equals("error")) {
                        logger.println(pluginName + "Error has occurred while uploading the file with response code: " + response.get("responseCode") + " : " + response.get("errorMessage") + ". Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                        throw new AbortException();
                    }
                    if (response.get("success").equals("false")) {
                        logger.println(pluginName + "Error has occurred in publishing result QMetry - Test Management for JIRA");
                        logger.println(pluginName + "Error Message: " + response.get("errorMessage") + " Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                        throw new AbortException();
                    }
                    if (response.get("success").equals("true")) {
                        logger.println(pluginName + "Publishing results has been successful.");
                        if (response.get("testRunUrl") != null) {
                            logger.println(pluginName + "Test run URL: " + response.get("testRunUrl"));
                        }
                        if (response.get("testRunKey") != null) {
                            logger.println(pluginName + "Test run Key: " + response.get("testRunKey"));
                        }
                        if (response.get("message") != null) {
                            logger.println(pluginName + "Message: " + response.get("message"));
                        }
                        if (response.get("testRunKey") == null && response.get("testRunUrl") == null && response.get("message") == null) {
                            logger.println(pluginName + "Response------>" + response.get("response"));
                        }
                    }
                }
                catch (ProtocolException e) {
                    try {
                        if (e.getMessage() != null) {
                            logger.println(pluginName + "Exception Message: " + e.getMessage());
                        }
                        logger.println(pluginName + "[ERROR] : ProtocolException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                        e.printStackTrace();
                        throw new AbortException();
                        catch (InvalidCredentialsException e10) {
                            if (e10.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e10.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : InvalidCredentialsException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e10.printStackTrace();
                            throw new AbortException();
                        }
                        catch (FileNotFoundException e11) {
                            if (e11.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e11.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : FileNotFoundException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e11.printStackTrace();
                            throw new AbortException();
                        }
                        catch (IOException e12) {
                            if (e12.getMessage() == null) throw new AbortException();
                            if (e12.getMessage().equals("CustomException")) throw new AbortException();
                            logger.println(pluginName + "Exception Message: " + e12.getMessage());
                            logger.println(pluginName + "[ERROR] : IOException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e12.printStackTrace();
                            throw new AbortException();
                        }
                        catch (ParseException e13) {
                            if (e13.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e13.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : ParseException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e13.printStackTrace();
                            throw new AbortException();
                        }
                        catch (Exception e14) {
                            if (e14.getMessage() != null) {
                                logger.println(pluginName + "Exception Message: " + e14.getMessage());
                            }
                            logger.println(pluginName + "[ERROR] : GeneralException has occurred in QMetry - Test Management for JIRA plugin.Please send these logs to " + "qtmforjira3support@smartbear.com" + " for more information");
                            e14.printStackTrace();
                            throw new AbortException();
                        }
                    }
                    catch (Throwable throwable) {
                        if (!FindFile.getOnSlave()) throw throwable;
                        if (FindFile.getQtm4jFile() == null) throw throwable;
                        try {
                            FileUtils.cleanDirectory((File)FindFile.getQtm4jFile());
                            throw throwable;
                        }
                        catch (IOException e15) {
                            listener.getLogger().println(pluginName + "Copying task failed");
                            throw throwable;
                        }
                        catch (IllegalArgumentException e16) {
                            listener.getLogger().println(pluginName + "Copying task failed");
                        }
                        throw throwable;
                    }
                }
                if (!FindFile.getOnSlave()) return;
                if (FindFile.getQtm4jFile() == null) return;
                try {
                    FileUtils.cleanDirectory((File)FindFile.getQtm4jFile());
                    return;
                }
                catch (IOException e) {
                    listener.getLogger().println(pluginName + "Copying task failed");
                    return;
                }
                catch (IllegalArgumentException e) {
                    listener.getLogger().println(pluginName + "Copying task failed");
                    return;
                }
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public ListBoxModel doFillFormatItems(@QueryParameter String format) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("testng/XML", "testng/xml", format.matches("testng/xml")), new ListBoxModel.Option("JUnit/XML", "junit/xml", format.matches("junit/xml")), new ListBoxModel.Option("qas/JSON", "qas/json", format.matches("qas/json")), new ListBoxModel.Option("Cucumber/JSON", "cucumber/json", format.matches("cucumber/json")), new ListBoxModel.Option("hpuft/XML", "hpuft/xml", format.matches("hpuft/xml")), new ListBoxModel.Option("SpecFlow/JSON", "specflow/json", format.matches("specflow/json"))});
        }

        public ListBoxModel doFillFormatserverItems(@QueryParameter String formatserver) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("testng/XML", "testng/xml", formatserver.matches("testng/xml")), new ListBoxModel.Option("JUnit/XML", "junit/xml", formatserver.matches("junit/xml")), new ListBoxModel.Option("qas/JSON", "qas/json", formatserver.matches("qas/json")), new ListBoxModel.Option("Cucumber/JSON", "cucumber/json", formatserver.matches("cucumber/json")), new ListBoxModel.Option("hpuft/XML", "hpuft/xml", formatserver.matches("hpuft/xml")), new ListBoxModel.Option("SpecFlow/JSON", "specflow/json", formatserver.matches("specflow/json"))});
        }

        public ListBoxModel doFillTestassethierarchyItems(@QueryParameter String testassethierarchy) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("TestScenario-TestCase", "TestScenario-TestCase", testassethierarchy.matches("TestScenario-TestCase")), new ListBoxModel.Option("TestCase-TestStep", "TestCase-TestStep", testassethierarchy.matches("TestCase-TestStep"))});
        }

        public ListBoxModel doFillTestassethierarchyserverItems(@QueryParameter String testassethierarchyserver) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("TestScenario-TestCase", "TestScenario-TestCase", testassethierarchyserver.matches("TestScenario-TestCase")), new ListBoxModel.Option("TestCase-TestStep", "TestCase-TestStep", testassethierarchyserver.matches("TestCase-TestStep"))});
        }

        public ListBoxModel doFillTestCaseUpdateLevelItems(@QueryParameter String testCaseUpdateLevel) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("(2) No change in test steps while reusing Test Case.", "2", testCaseUpdateLevel.matches("2")), new ListBoxModel.Option("(1) Override test steps while reusing Test Case.", "1", testCaseUpdateLevel.matches("1")), new ListBoxModel.Option("(0) Append test steps while reusing Test Case.", "0", testCaseUpdateLevel.matches("0"))});
        }

        public ListBoxModel doFillTestCaseUpdateLevelServerItems(@QueryParameter String testCaseUpdateLevelServer) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("(2) No change in test steps while reusing Test Case.", "2", testCaseUpdateLevelServer.matches("2")), new ListBoxModel.Option("(1) Override test steps while reusing Test Case.", "1", testCaseUpdateLevelServer.matches("1")), new ListBoxModel.Option("(0) Append test steps while reusing Test Case.", "0", testCaseUpdateLevelServer.matches("0"))});
        }

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckApikey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFile(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApikeyserver(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJiraurlserver(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPersonalAccessToken(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0 || StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFileserver(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJirafields(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() != 0) {
                try {
                    new JSONArray(value);
                }
                catch (JSONException e) {
                    return FormValidation.error((String)"Invalid JSON");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJirafieldsserver(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() != 0) {
                try {
                    new JSONArray(value);
                }
                catch (JSONException e) {
                    return FormValidation.error((String)"Invalid JSON");
                }
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish results to QMetry for Jira version 3.X below";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

