/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.disk;

import com.cloudbees.simplediskusage.DiskItem;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import org.jenkinsci.plugins.prometheus.collectors.BaseMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;

public class DiskUsageFileCountGauge
extends BaseMetricCollector<DiskItem, Gauge> {
    protected DiskUsageFileCountGauge(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.DISK_USAGE_FILE_COUNT_GAUGE;
    }

    @Override
    protected String getHelpText() {
        return "Disk usage file count of the first level folder in JENKINS_HOME";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    @Override
    public void calculateMetric(DiskItem jenkinsObject, String[] labelValues) {
        if (jenkinsObject == null) {
            return;
        }
        Long count = jenkinsObject.getCount();
        if (count == null) {
            return;
        }
        ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set((double)count.longValue());
    }
}

