/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.builds;

import hudson.model.Run;
import io.prometheus.client.Collector;
import java.util.Arrays;
import java.util.HashMap;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildCollectorFactory;
import org.jenkinsci.plugins.prometheus.util.ConfigurationUtils;

public class CounterManager {
    private final HashMap<CounterEntry, MetricCollector<Run<?, ?>, ? extends Collector>> registeredCounters = new HashMap();
    private static CounterManager manager;

    private CounterManager() {
    }

    public static CounterManager getManager() {
        if (manager == null) {
            manager = new CounterManager();
        }
        return manager;
    }

    private Boolean hasCounter(CounterEntry entry) {
        return this.registeredCounters.containsKey(entry);
    }

    public MetricCollector<Run<?, ?>, ? extends Collector> getCounter(CollectorType type, String[] labels, String prefix) {
        CounterEntry entry = new CounterEntry(type, labels, prefix);
        if (this.hasCounter(entry).booleanValue()) {
            return this.registeredCounters.get(entry);
        }
        BuildCollectorFactory factory = new BuildCollectorFactory();
        MetricCollector<Run<?, ?>, ? extends Collector> counterCollector = factory.createCollector(type, labels, prefix);
        this.registeredCounters.put(entry, counterCollector);
        return counterCollector;
    }

    private static class CounterEntry {
        private final String[] labels;
        private final CollectorType type;
        private final String prefix;
        private final String namespace;

        public CounterEntry(CollectorType type, String[] labels, String prefix) {
            this.labels = labels;
            this.type = type;
            this.prefix = prefix;
            this.namespace = ConfigurationUtils.getNamespace();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CounterEntry entry = (CounterEntry)obj;
            if (this.prefix != null && !this.prefix.equals(entry.prefix)) {
                return false;
            }
            if (this.type != entry.type) {
                return false;
            }
            if (this.namespace != null && !this.namespace.equals(entry.namespace)) {
                return false;
            }
            return Arrays.equals(this.labels, entry.labels);
        }

        public int hashCode() {
            int typeHash = this.type != null ? this.type.hashCode() : 0;
            int prefixHash = this.prefix != null ? this.prefix.hashCode() : 0;
            int namespaceHash = this.namespace != null ? this.namespace.hashCode() : 0;
            return 31 * (typeHash + Arrays.hashCode(this.labels) + prefixHash + namespaceHash);
        }
    }
}

