/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.builds;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BuildCompletionListener
extends RunListener<Run<?, ?>> {
    private static BuildCompletionListener _Listener;
    private final Lock lock;
    private final List<Run<?, ?>> runStack = Collections.synchronizedList(new ArrayList());

    protected BuildCompletionListener() {
        this.lock = new ReentrantLock();
    }

    public void unregister() {
        super.unregister();
        try {
            this.lock.lock();
            this.runStack.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Extension
    public static synchronized BuildCompletionListener getInstance() {
        if (_Listener == null) {
            _Listener = new BuildCompletionListener();
        }
        return _Listener;
    }

    public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
        this.push(run);
    }

    private synchronized void push(Run<?, ?> run) {
        this.lock.lock();
        try {
            this.runStack.add(run);
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized CloseableIterator<Run<?, ?>> iterator() {
        this.lock.lock();
        return new CloseableIterator<Run<?, ?>>(){
            private final Iterator<Run<?, ?>> iterator;
            {
                this.iterator = BuildCompletionListener.this.runStack.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Run<?, ?> next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }

            @Override
            public void close() {
                BuildCompletionListener.this.runStack.clear();
                BuildCompletionListener.this.lock.unlock();
            }
        };
    }

    List<Run<?, ?>> getRunStack() {
        return this.runStack;
    }

    public static interface CloseableIterator<T>
    extends Iterator<T>,
    AutoCloseable {
        @Override
        public void close();
    }
}

