/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

public class Marker {
    private final String title;
    private final String icon;
    private final String description;
    private final int lineStart;
    private final int lineEnd;
    private final int columnStart;
    private final int columnEnd;

    Marker(String title, String icon, String description, int lineStart, int lineEnd, int columnStart, int columnEnd) {
        this.title = title;
        this.icon = icon;
        this.description = description;
        this.lineStart = lineStart;
        this.lineEnd = lineEnd;
        this.columnStart = columnStart;
        this.columnEnd = columnEnd;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public int getColumnStart() {
        return this.columnStart;
    }

    public int getColumnEnd() {
        return this.columnEnd;
    }

    public static class MarkerBuilder {
        private String title = "";
        private String icon = "";
        private String description = "";
        private int lineStart;
        private int lineEnd;
        private int columnStart;
        private int columnEnd;

        public MarkerBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public MarkerBuilder withIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public MarkerBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public MarkerBuilder withLineStart(int lineStart) {
            this.lineStart = lineStart;
            return this;
        }

        public MarkerBuilder withLineEnd(int lineEnd) {
            this.lineEnd = lineEnd;
            return this;
        }

        public MarkerBuilder withColumnStart(int columnStart) {
            this.columnStart = columnStart;
            return this;
        }

        public MarkerBuilder withColumnEnd(int columnEnd) {
            this.columnEnd = columnEnd;
            return this;
        }

        public Marker build() {
            int providedColumnEnd;
            int providedLineEnd;
            int providedLineStart = this.defaultInteger(this.lineStart);
            int n = providedLineEnd = this.defaultInteger(this.lineEnd) == 0 ? providedLineStart : this.defaultInteger(this.lineEnd);
            if (providedLineStart == 0) {
                this.lineStart = providedLineEnd;
                this.lineEnd = providedLineEnd;
            } else {
                this.lineStart = Math.min(providedLineStart, providedLineEnd);
                this.lineEnd = Math.max(providedLineStart, providedLineEnd);
            }
            int providedColumnStart = this.defaultInteger(this.columnStart);
            int n2 = providedColumnEnd = this.defaultInteger(this.columnEnd) == 0 ? providedColumnStart : this.defaultInteger(this.columnEnd);
            if (providedColumnStart == 0) {
                this.columnStart = providedColumnEnd;
                this.columnEnd = providedColumnEnd;
            } else {
                this.columnStart = Math.min(providedColumnStart, providedColumnEnd);
                this.columnEnd = Math.max(providedColumnStart, providedColumnEnd);
            }
            return new Marker(this.title, this.icon, this.description, this.lineStart, this.lineEnd, this.columnStart, this.columnEnd);
        }

        private int defaultInteger(int integer) {
            return Math.max(integer, 0);
        }
    }
}

