/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.ResultHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class QualityGateEvaluator<T extends QualityGate> {
    private final List<T> qualityGates = new ArrayList<T>();

    @VisibleForTesting
    QualityGateEvaluator() {
        this(List.of());
    }

    protected QualityGateEvaluator(Collection<? extends T> qualityGates) {
        this.qualityGates.addAll(qualityGates);
    }

    public QualityGateResult evaluate(ResultHandler resultHandler, FilteredLog log) {
        QualityGateResult result = this.createResult();
        if (this.qualityGates.isEmpty()) {
            log.logInfo("No quality gates have been set - skipping");
        } else {
            log.logInfo("Evaluating quality gates");
            for (QualityGate qualityGate : this.qualityGates) {
                this.evaluate(qualityGate, result);
            }
            if (result.isSuccessful()) {
                log.logInfo("-> All quality gates have been passed");
            } else {
                String message2 = "-> Some quality gates have been missed: overall result is %s".formatted(result.getOverallStatus().getResult());
                log.logInfo(message2);
                resultHandler.publishResult(result.getOverallStatus(), message2);
            }
            log.logInfo("-> Details for each quality gate:");
            result.getMessages().forEach(message -> log.logInfo("   - " + message));
        }
        return result;
    }

    @VisibleForTesting
    QualityGateResult createResult() {
        return new QualityGateResult();
    }

    protected abstract void evaluate(T var1, QualityGateResult var2);

    public void addAll(Collection<? extends T> additionalQualityGates) {
        this.qualityGates.addAll(additionalQualityGates);
    }

    public boolean isEnabled() {
        return !this.qualityGates.isEmpty();
    }
}

