/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.util.CSharpNamespaceDetector;
import edu.hm.hafner.util.JavaPackageDetector;
import edu.hm.hafner.util.KotlinPackageDetector;
import edu.hm.hafner.util.PackageDetectorRunner;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class PackageDetectorFactory {
    public static PackageDetectorRunner createPackageDetectors() {
        return PackageDetectorFactory.createPackageDetectors(new FileSystemFacade());
    }

    @VisibleForTesting
    public static PackageDetectorRunner createPackageDetectors(FileSystemFacade facade) {
        return new PackageDetectorRunner(new JavaPackageDetector(facade), new KotlinPackageDetector(facade), new CSharpNamespaceDetector(facade));
    }

    private PackageDetectorFactory() {
    }

    @VisibleForTesting
    public static class FileSystemFacade {
        @MustBeClosed
        public InputStream openFile(String fileName) throws IOException, InvalidPathException {
            return Files.newInputStream(Path.of(fileName, new String[0]), new OpenOption[0]);
        }
    }
}

