/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.tar;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileDecompressStep;
import org.jenkinsci.plugins.pipeline.utility.steps.tar.UnTarStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class UnTarStep
extends AbstractFileDecompressStep {
    private boolean keepPermissions = true;

    @DataBoundConstructor
    public UnTarStep(String file) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("Can not be empty", "file");
        }
        this.setFile(file);
    }

    public boolean isKeepPermissions() {
        return this.keepPermissions;
    }

    @DataBoundSetter
    public void setKeepPermissions(boolean keepPermissions) {
        this.keepPermissions = keepPermissions;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new UnTarStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "untar";
        }

        @NonNull
        public String getDisplayName() {
            return "Extract Tar file";
        }
    }
}

