/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.Extension;
import hudson.FilePath;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.remoting.Channel;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.output.TeeOutputStream;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class TeeStep
extends Step {
    public final String file;

    @DataBoundConstructor
    public TeeStep(String file) {
        this.file = file;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.file);
    }

    private static OutputStream append(FilePath fp, OutputStream stream) throws IOException, InterruptedException {
        if (stream == null) {
            return (OutputStream)fp.act((FilePath.FileCallable)new CreateRemoteStreamCallable());
        }
        return stream;
    }

    private static class Execution
    extends StepExecution {
        private final String file;
        private static final long serialVersionUID = 1L;

        Execution(StepContext context, String file) {
            super(context);
            this.file = file;
        }

        public boolean start() throws Exception {
            FilePath f = ((FilePath)this.getContext().get(FilePath.class)).child(this.file);
            TeeFilter filter = new TeeFilter(f);
            this.getContext().newBodyInvoker().withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)filter)).withCallback((BodyExecutionCallback)new TeeTail(filter)).start();
            return false;
        }
    }

    private static final class CreateRemoteStreamCallable
    extends MasterToSlaveFileCallable<OutputStream> {
        private static final long serialVersionUID = 1L;

        private CreateRemoteStreamCallable() {
        }

        public OutputStream invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            if (!(f = f.getAbsoluteFile()).getParentFile().exists() && !f.getParentFile().mkdirs()) {
                throw new IOException("Failed to create directory " + f.getParentFile());
            }
            try {
                return new RemoteOutputStream(Files.newOutputStream(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND));
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "tee";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Tee output to file";
        }
    }

    private static class TeeFilter
    extends ConsoleLogFilter
    implements Serializable {
        private final FilePath f;
        private boolean transferredToRemote = false;
        private transient OutputStream stream = null;
        private static final long serialVersionUID = 1L;

        TeeFilter(FilePath f) {
            this.f = f;
        }

        public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
            this.stream = TeeStep.append(this.f, this.stream);
            return new TeeOutputStream(logger, this.stream);
        }

        void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }

        private void writeObject(ObjectOutputStream oos) throws IOException, InterruptedException {
            this.transferredToRemote = Channel.current() != null;
            oos.defaultWriteObject();
            boolean saveStream = this.transferredToRemote;
            this.transferredToRemote = false;
            if (saveStream) {
                this.stream = TeeStep.append(this.f, this.stream);
                oos.writeObject(this.stream);
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            boolean saveStream = this.transferredToRemote;
            this.transferredToRemote = false;
            if (saveStream) {
                this.stream = (OutputStream)ois.readObject();
            }
        }
    }

    private static final class TeeTail
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final TeeFilter filter;

        TeeTail(TeeFilter filter) {
            this.filter = filter;
        }

        protected void finished(StepContext sc) throws Exception {
            this.filter.close();
        }
    }
}

