/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.FileWrapper;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PrependToFileStep
extends Step {
    private final String file;
    private final String content;

    @DataBoundConstructor
    public PrependToFileStep(String file, String content) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("can't be blank", "file");
        }
        this.file = file;
        if (StringUtils.isBlank((String)content)) {
            throw new Descriptor.FormException("can't be blank", "content");
        }
        this.content = content;
    }

    public String getFile() {
        return this.file;
    }

    public String getContent() {
        return this.content;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(this, context);
    }

    public static class ExecutionImpl
    extends SynchronousNonBlockingStepExecution<FileWrapper> {
        private static final long serialVersionUID = 1L;
        private transient PrependToFileStep step;

        protected ExecutionImpl(@NonNull PrependToFileStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected FileWrapper run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            FilePath file = ws.child(this.step.getFile());
            FilePath parent = file.getParent();
            if (!file.exists() && parent != null) {
                parent.mkdirs();
                file.touch(System.currentTimeMillis());
            } else if (parent == null) {
                throw new IOException("No parent path for " + file.getRemote());
            }
            String content = this.step.getContent();
            String originalContent = file.readToString();
            String newContent = content + originalContent;
            file.write(newContent, StandardCharsets.UTF_8.name());
            return new FileWrapper(file);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "prependToFile";
        }

        public String getDisplayName() {
            return "Create a file (if not already exist) in the workspace, and prepend given content to that file.";
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckContent(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }
    }
}

