/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.ComputeHashCallable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.QueryParameter;

public abstract class FileHashStep
extends Step {
    private final String file;
    private final String hashAlgorithm;

    public FileHashStep(String file, @NonNull String hashAlgorithm) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("can't be blank", "file");
        }
        this.file = file;
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getFile() {
        return this.file;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(this, context);
    }

    public static class ExecutionImpl
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private final transient FileHashStep step;

        protected ExecutionImpl(@NonNull FileHashStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            FilePath filePath = ws.child(this.step.getFile());
            return (String)filePath.act((FilePath.FileCallable)new ComputeHashCallable(this.step.getHashAlgorithm()));
        }
    }

    public static abstract class DescriptorImpl
    extends StepDescriptor {
        private final String algorithm;

        public DescriptorImpl(String algorithm) {
            this.algorithm = algorithm;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return this.algorithm.toLowerCase(Locale.ENGLISH);
        }

        @NonNull
        public String getDisplayName() {
            return "Compute the " + this.algorithm.toUpperCase(Locale.ENGLISH) + " of a given file";
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }
    }
}

