/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Result;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;

public enum StatusExt {
    NOT_EXECUTED,
    ABORTED,
    SUCCESS,
    IN_PROGRESS,
    PAUSED_PENDING_INPUT,
    FAILED,
    UNSTABLE;


    public static StatusExt valueOf(ErrorAction errorAction) {
        if (errorAction == null) {
            return SUCCESS;
        }
        return StatusExt.valueOf(errorAction.getError());
    }

    public static StatusExt valueOf(Throwable t) {
        if (t instanceof FlowInterruptedException) {
            FlowInterruptedException exception = (FlowInterruptedException)t;
            return exception.isActualInterruption() ? ABORTED : FAILED;
        }
        return FAILED;
    }

    public static StatusExt valueOf(Result r) {
        if (r == Result.NOT_BUILT) {
            return NOT_EXECUTED;
        }
        if (r == Result.ABORTED) {
            return ABORTED;
        }
        if (r == Result.FAILURE) {
            return FAILED;
        }
        if (r == Result.UNSTABLE) {
            return UNSTABLE;
        }
        if (r == Result.SUCCESS) {
            return SUCCESS;
        }
        throw new IllegalStateException("Illegal Result type: " + r);
    }

    public static StatusExt fromGenericStatus(@CheckForNull GenericStatus st) {
        if (st == null) {
            return NOT_EXECUTED;
        }
        switch (st) {
            case PAUSED_PENDING_INPUT: {
                return PAUSED_PENDING_INPUT;
            }
            case ABORTED: {
                return ABORTED;
            }
            case FAILURE: {
                return FAILED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case UNSTABLE: {
                return UNSTABLE;
            }
            case SUCCESS: {
                return SUCCESS;
            }
            case NOT_EXECUTED: {
                return NOT_EXECUTED;
            }
        }
        throw new IllegalStateException("Forbidden GenericStatus: " + st);
    }
}

